package com.elitescloud.boot.mq.compensate.controller;

import com.elitescloud.boot.mq.compensate.model.vo.SysRocketMqConsumeFailLogVO;
import com.elitescloud.boot.mq.compensate.param.SysRocketMqConsumeFailLogCreateParam;
import com.elitescloud.boot.mq.compensate.param.SysRocketMqConsumeFailLogQueryParam;
import com.elitescloud.boot.mq.compensate.service.SysRocketMqConsumeFailLogService;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.val;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author roman.zhang
 * @since 2022-04-01 16:07:22
 */
@ResponseBody
@RequestMapping("/sys/sysRocketMqConsumeFailLog")
@Api(value = "架构补偿机制-消费失败记录", tags = {"架构补偿机制-消费失败记录"})
public class SysRocketMqConsumeFailLogController {

    @Autowired
    private SysRocketMqConsumeFailLogService sysRocketMqConsumeFailLogService;

    @PostMapping("/sendFailMessage")
    @ApiOperation("手动发送消息，传consumerKey")
    ApiResult<Object>  sendFailMessage(@RequestBody SysRocketMqConsumeFailLogQueryParam param){
        sysRocketMqConsumeFailLogService.sendFailMessage(param);
        return ApiResult.ok();
    }
   
    /**
     * 通过主键查询单条数据
     *
     * @param id 主键
     * @return 单条数据
     */
    @GetMapping("/findIdOne/{id}")
    @ApiOperation("通过主键查询单条数据")
    ApiResult<SysRocketMqConsumeFailLogVO>  findIdOne(@PathVariable  Long id){
        return sysRocketMqConsumeFailLogService.findIdOne(id).map(ApiResult::ok)
        .orElse(ApiResult.fail(ApiCode.NOT_FOUND));
    }
    
    /**
     * 根据关键字段查询数据
     * @param key 参数
     * @return 数据
     */
    @GetMapping("/findCodeOne/{key}")
    @ApiOperation("根据关键字段查询数据")
    public ApiResult<SysRocketMqConsumeFailLogVO>  findCodeOne(@PathVariable  String key){
        return sysRocketMqConsumeFailLogService.findCodeOne(key).map(ApiResult::ok)
        .orElse(ApiResult.fail(ApiCode.NOT_FOUND));
    }
    
    /**
     * 分页查询
     *
     * @param param 分类查询、分页和排序对象
     * @return 多条数据
     */
    @PostMapping("/search")
    @ApiOperation("分页查询")
    public  ApiResult<PagingVO<SysRocketMqConsumeFailLogVO>> search(@RequestBody SysRocketMqConsumeFailLogQueryParam param){
        val ret = sysRocketMqConsumeFailLogService.search(param);
        return ApiResult.ok(ret); 
    }
    
     /**
     * 新增数据
     *
     * @param param 新增数据
     * @return 新增数据情况
     */
    @PostMapping("/createOne")
    @ApiOperation("新增数据")
    public ApiResult<Object> createOne(@RequestBody SysRocketMqConsumeFailLogCreateParam param){
         return  ApiResult.ok( sysRocketMqConsumeFailLogService.createOne(param));
    }
    /**
     * 批量新增数据
     *
     * @param list 对象集合
     */
    @PostMapping("/createBatch")
    @ApiOperation("批量新增数据")
    public ApiResult<Object> createBatch(@RequestBody List<SysRocketMqConsumeFailLogCreateParam> list){
        return ApiResult.ok( sysRocketMqConsumeFailLogService.createBatch(list));
    }
    
//   /**
//     * 修改数据
//     *
//     * @param param 修改对象
//     * @return 修改数据详情
//     */
//    @PutMapping("/update")
//    @ApiOperation("修改数据")
//    public ApiResult<Object> update(@RequestBody SysRocketMqConsumeFailLogUpdateParam param){
//        sysRocketMqConsumeFailLogService.update(param);
//        return ApiResult.ok();
//    }
    
    /**
     * 根据主键删除数据
     *
     * @param  id 主键
     * @return 删除情况
     */
    @DeleteMapping("/deleteOne/{id}")
    @ApiOperation("根据主键删除数据")
    public ApiResult<Object> deleteOne(@PathVariable Long id){
        sysRocketMqConsumeFailLogService.deleteOne(id);
        return ApiResult.ok();
    }
    
    /**
     * 批量删除
     *
     * @param ids 删除数据集合
     */
    @DeleteMapping("/deleteBatch")
    @ApiOperation("批量删除")
    public ApiResult<Object> deleteBatch(@RequestBody List<Long> ids){
        sysRocketMqConsumeFailLogService.deleteBatch(ids);
        return ApiResult.ok();
    }
    
    /**
     * 逻辑删除
     *
     * @param id 更新数据
     */
    @PutMapping("/updateDeleteFlag/{id}")
    @ApiOperation("逻辑删除")
    public ApiResult<Object> updateDeleteFlag(@PathVariable Long id){
        sysRocketMqConsumeFailLogService.updateDeleteFlag(id);
        return ApiResult.ok();
    }
}


