package com.elitescloud.boot.mq.compensate.repo;

import com.elitescloud.boot.mq.compensate.model.entity.QSysRocketMqConsumeFailLogDO;
import com.elitescloud.boot.mq.compensate.model.vo.SysRocketMqConsumeFailLogVO;
import com.elitescloud.boot.mq.compensate.param.SysRocketMqConsumeFailLogQueryParam;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import lombok.val;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;

/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author roman.zhang
 * @since 2022-04-01 16:06:21
 */
@Repository
@RequiredArgsConstructor
public class SysRocketMqConsumeFailLogRepoProc {

     private final JPAQueryFactory jpaQueryFactory;

    /**
     * 查询字段
     *
     */ 
    public  JPAQuery<SysRocketMqConsumeFailLogVO> select(SysRocketMqConsumeFailLogQueryParam param){
        QSysRocketMqConsumeFailLogDO jpaQDo = QSysRocketMqConsumeFailLogDO.sysRocketMqConsumeFailLogDO;
        Predicate predicate = jpaQDo.isNotNull();
        JPAQuery<SysRocketMqConsumeFailLogVO> jpaQuery=jpaQueryFactory.select(Projections.bean(SysRocketMqConsumeFailLogVO.class,
                                jpaQDo.id,                
                                jpaQDo.typeId,                
                                jpaQDo.alreadyDeal,                
                                jpaQDo.consumerKey,
                                jpaQDo.consumerGroup,                
                                jpaQDo.consumerTopic,                
                                jpaQDo.consumerBoby,
                                jpaQDo.tenantId,                
                                jpaQDo.remark,                
                                jpaQDo.createUserId,                
                                jpaQDo.creator,                
                                jpaQDo.createTime,                
                                jpaQDo.modifyUserId,                
                                jpaQDo.updater,                
                                jpaQDo.modifyTime,                
                                jpaQDo.deleteFlag,                
                                jpaQDo.auditDataVersion,                
                                jpaQDo.secBuId,                
                                jpaQDo.secUserId,                
                                jpaQDo.secOuId                
                                )).from(jpaQDo);
        if(param != null){
           jpaQuery.where(where(param));
        }
        jpaQuery.where(predicate,jpaQDo.deleteFlag.eq(0).or(jpaQDo.deleteFlag.isNull()));
        return jpaQuery;
    }

    public  JPAQuery<SysRocketMqConsumeFailLogVO> selectOptional(SysRocketMqConsumeFailLogQueryParam param){
        QSysRocketMqConsumeFailLogDO jpaQDo = QSysRocketMqConsumeFailLogDO.sysRocketMqConsumeFailLogDO;
        Predicate predicate = jpaQDo.isNotNull();
        JPAQuery<SysRocketMqConsumeFailLogVO> jpaQuery=jpaQueryFactory.select(Projections.bean(SysRocketMqConsumeFailLogVO.class,
                jpaQDo.id,
                jpaQDo.typeId,
                jpaQDo.alreadyDeal,
                jpaQDo.consumerKey,
                jpaQDo.consumerGroup,
                jpaQDo.consumerTopic,
                jpaQDo.consumerBoby,
                jpaQDo.consumerTag,
                jpaQDo.createUserId
        )).from(jpaQDo);
        if(param != null){
            jpaQuery.where(where(param));
        }
        jpaQuery.where(predicate,jpaQDo.deleteFlag.eq(0).or(jpaQDo.deleteFlag.isNull()));
        return jpaQuery;
    }
     /**
     * 根据主键查询
     *
     * @param  id 主键
     */ 
    public Predicate where(Long id) {
        val jpaQDo = QSysRocketMqConsumeFailLogDO.sysRocketMqConsumeFailLogDO;
                Predicate predicate = jpaQDo.isNotNull().or(jpaQDo.isNull());
        ExpressionUtils.and(predicate, jpaQDo.id.eq(id));
        return predicate;
    }
   /**
     * 条件查询
     *
     * @param  param 查询条件
     */ 
    public Predicate where(SysRocketMqConsumeFailLogQueryParam param) {
        val jpaQDo = QSysRocketMqConsumeFailLogDO.sysRocketMqConsumeFailLogDO;
                Predicate predicate = jpaQDo.isNotNull().or(jpaQDo.isNull());
                   if (!StringUtils.isEmpty(param.getId())) {
          predicate = ExpressionUtils.and(predicate, jpaQDo.id.eq(param.getId()));
          }
                   if (!StringUtils.isEmpty(param.getTypeId())) {
          predicate = ExpressionUtils.and(predicate, jpaQDo.typeId.eq(param.getTypeId()));
          }
                   if (!StringUtils.isEmpty(param.getAlreadyDeal())) {
          predicate = ExpressionUtils.and(predicate, jpaQDo.alreadyDeal.eq(param.getAlreadyDeal()));
          }
                   if (!StringUtils.isEmpty(param.getConsumerKey())) {
          predicate = ExpressionUtils.and(predicate, jpaQDo.consumerKey.eq(param.getConsumerKey()));
          }
                   if (!StringUtils.isEmpty(param.getConsumerGroup())) {
          predicate = ExpressionUtils.and(predicate, jpaQDo.consumerGroup.eq(param.getConsumerGroup()));
          }
                   if (!StringUtils.isEmpty(param.getConsumerTopic())) {
          predicate = ExpressionUtils.and(predicate, jpaQDo.consumerTopic.eq(param.getConsumerTopic()));
          }
                   if (!StringUtils.isEmpty(param.getTenantId())) {
          predicate = ExpressionUtils.and(predicate, jpaQDo.tenantId.eq(param.getTenantId()));
          }
                   if (!StringUtils.isEmpty(param.getRemark())) {
          predicate = ExpressionUtils.and(predicate, jpaQDo.remark.eq(param.getRemark()));
          }
                   if (!StringUtils.isEmpty(param.getCreateUserId())) {
          predicate = ExpressionUtils.and(predicate, jpaQDo.createUserId.eq(param.getCreateUserId()));
          }
                   if (!StringUtils.isEmpty(param.getCreator())) {
          predicate = ExpressionUtils.and(predicate, jpaQDo.creator.eq(param.getCreator()));
          }
                   if (!StringUtils.isEmpty(param.getModifyUserId())) {
          predicate = ExpressionUtils.and(predicate, jpaQDo.modifyUserId.eq(param.getModifyUserId()));
          }
                   if (!StringUtils.isEmpty(param.getUpdater())) {
          predicate = ExpressionUtils.and(predicate, jpaQDo.updater.eq(param.getUpdater()));
          }
                   if (!StringUtils.isEmpty(param.getDeleteFlag())) {
          predicate = ExpressionUtils.and(predicate, jpaQDo.deleteFlag.eq(param.getDeleteFlag()));
          }
                   if (!StringUtils.isEmpty(param.getAuditDataVersion())) {
          predicate = ExpressionUtils.and(predicate, jpaQDo.auditDataVersion.eq(param.getAuditDataVersion()));
          }
                   if (!StringUtils.isEmpty(param.getSecBuId())) {
          predicate = ExpressionUtils.and(predicate, jpaQDo.secBuId.eq(param.getSecBuId()));
          }
                   if (!StringUtils.isEmpty(param.getSecUserId())) {
          predicate = ExpressionUtils.and(predicate, jpaQDo.secUserId.eq(param.getSecUserId()));
          }
                   if (!StringUtils.isEmpty(param.getSecOuId())) {
          predicate = ExpressionUtils.and(predicate, jpaQDo.secOuId.eq(param.getSecOuId()));
          }
                  return predicate;
    }
}

