package com.elitescloud.boot.mq.compensate.service;

import com.elitescloud.boot.mq.compensate.model.vo.SysRocketMqConsumeFailLogVO;
import com.elitescloud.boot.mq.compensate.param.SysRocketMqConsumeFailLogCreateParam;
import com.elitescloud.boot.mq.compensate.param.SysRocketMqConsumeFailLogQueryParam;
import com.elitescloud.cloudt.common.base.PagingVO;

import java.util.List;
import java.util.Optional;
/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author roman.zhang
 * @since 2022-04-01 16:06:16
 */
public interface SysRocketMqConsumeFailLogService {
 /**
     * 检索 
     * @param queryParam 分类查询、分页和排序对象
     * @return 分页结果集
     */
    PagingVO<SysRocketMqConsumeFailLogVO> search(SysRocketMqConsumeFailLogQueryParam queryParam);

    /**
     * 根据关键字段，返回对应的vo
     * @param Code  code
     * @return  对象
     */
    Optional<SysRocketMqConsumeFailLogVO> findCodeOne(String Code);
    /**
     * 根据关键字段，返回对应的
     * @param Id ID
     * @return 对象
     */
    Optional<SysRocketMqConsumeFailLogVO> findIdOne(Long Id);
    /**
     * 根据关键字段，返回对应的
     * @param idList ID集合
     * @return 对象
     */
   List<SysRocketMqConsumeFailLogVO>  findIdBatch(List<Long> idList);
    /**
     * 创建
     *
     * @param  creatParam 对象
     */
    Long createOne(SysRocketMqConsumeFailLogCreateParam creatParam);
    /**
     * 创建
     *
     * @param List 对象集合
     */
    List<Long> createBatch(List<SysRocketMqConsumeFailLogCreateParam> List);
//    /**
//     * 更新
//     *
//     * @param  updateParam 对象
//     */
//    void update(SysRocketMqConsumeFailLogUpdateParam updateParam) ;

    /**
     * 删除
     *
     * @param Id 对象
     */
    void deleteOne(Long Id);
    /**
     * 删除
     *
     * @param idList 对象集合
     */
    void deleteBatch(List<Long> idList);

    /**
     * 更新删除标识
     *
     * @param id id
     */
    void updateDeleteFlag(Long id);

    /**
     * 手动消费
     * @param topic
     * @param tag
     */
    void sendFailMessage(SysRocketMqConsumeFailLogQueryParam param);
}


