package com.elitescloud.boot.mq.compensate.service.impl;

import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.mq.compensate.convert.SysRocketMqConsumeFailLogConvert;
import com.elitescloud.boot.mq.compensate.model.entity.QSysRocketMqConsumeFailLogDO;
import com.elitescloud.boot.mq.compensate.model.entity.SysRocketMqConsumeFailLogDO;
import com.elitescloud.boot.mq.compensate.model.vo.SysRocketMqConsumeFailLogVO;
import com.elitescloud.boot.mq.compensate.param.SysRocketMqConsumeFailLogCreateParam;
import com.elitescloud.boot.mq.compensate.param.SysRocketMqConsumeFailLogQueryParam;
import com.elitescloud.boot.mq.compensate.repo.SysRocketMqConsumeFailLogRepo;
import com.elitescloud.boot.mq.compensate.repo.SysRocketMqConsumeFailLogRepoProc;
import com.elitescloud.boot.mq.compensate.service.SysRocketMqConsumeFailLogService;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.boot.exception.BusinessException;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQuery;
import lombok.val;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.client.producer.SendStatus;
import org.apache.rocketmq.common.message.MessageConst;
import org.apache.rocketmq.spring.core.RocketMQTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.Message;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.transaction.annotation.Transactional;

import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author roman.zhang
 * @since 2022-04-01 16:06:17
 */
public class SysRocketMqConsumeFailLogServiceImpl implements SysRocketMqConsumeFailLogService {

    @Autowired
    private SysRocketMqConsumeFailLogRepo sysRocketMqConsumeFailLogRepo;

    @Autowired
    private SysRocketMqConsumeFailLogRepoProc sysRocketMqConsumeFailLogRepoProc;

    @Autowired
    private RocketMQTemplate rocketMQTemplate;
    
 
    @Override
    @SysCodeProc
    public PagingVO<SysRocketMqConsumeFailLogVO> search(SysRocketMqConsumeFailLogQueryParam param){
        val ret = sysRocketMqConsumeFailLogRepo.findAll(sysRocketMqConsumeFailLogRepoProc.where(param), param.getPageRequest());
        val vos = ret.getContent().stream().map(SysRocketMqConsumeFailLogConvert.INSTANCE::doToVO).collect(Collectors.toList());
        vos.stream().filter(v->v.getConsumerBoby()!=null).forEach(v->{
            v.setConsumerBobyString( byteToString(v.getConsumerBoby()));
        });
        return PagingVO.<SysRocketMqConsumeFailLogVO>builder()
                .total(ret.getTotalElements())
                .records(vos)
                .build();
    }
 
    @Override
    @SysCodeProc
    public Optional<SysRocketMqConsumeFailLogVO> findCodeOne(String itemCode) {
        JPAQuery<SysRocketMqConsumeFailLogVO> jpaQuery = sysRocketMqConsumeFailLogRepoProc.select(null);
        val jpaQDo = QSysRocketMqConsumeFailLogDO.sysRocketMqConsumeFailLogDO;
        //设置查询条件
        //jpaQuery.where(jpaQDo.itemCode.eq(itemCode));
        SysRocketMqConsumeFailLogVO vo = jpaQuery.fetchOne();
        return Optional.ofNullable(vo);
    }
    @Override
    @SysCodeProc
    public Optional<SysRocketMqConsumeFailLogVO> findIdOne(Long id) {
        return sysRocketMqConsumeFailLogRepo.findById(id).map(SysRocketMqConsumeFailLogConvert.INSTANCE::doToVO);
    }
    
    @Override
    @SysCodeProc
    public List<SysRocketMqConsumeFailLogVO> findIdBatch(List<Long> idList) {
         return sysRocketMqConsumeFailLogRepo.findAllById(idList).stream().map(
               SysRocketMqConsumeFailLogConvert.INSTANCE::doToVO
        ).collect(Collectors.toList());
    }

    
    
    @Override
    @Transactional
    public Long createOne(SysRocketMqConsumeFailLogCreateParam param){
       SysRocketMqConsumeFailLogDO sysRocketMqConsumeFailLogDO = SysRocketMqConsumeFailLogConvert.INSTANCE.creatParamToDo(param);
       return sysRocketMqConsumeFailLogRepo.save(sysRocketMqConsumeFailLogDO).getId();
    }
    
    @Override
    @Transactional
    public List<Long> createBatch(List<SysRocketMqConsumeFailLogCreateParam> list){
        List<SysRocketMqConsumeFailLogDO> dos = list.stream().map(SysRocketMqConsumeFailLogConvert.INSTANCE::creatParamToDo).collect(Collectors.toList());
       return sysRocketMqConsumeFailLogRepo.saveAll(dos).stream().map(SysRocketMqConsumeFailLogDO::getId).collect(Collectors.toList());
    }
    
//    @Override
//    @Transactional
//    public void update(SysRocketMqConsumeFailLogUpdateParam param) {
//      SysRocketMqConsumeFailLogDO objDo = SysRocketMqConsumeFailLogConvert.INSTANCE.updateParamToDo(param);
//        Optional<SysRocketMqConsumeFailLogDO> optional = sysRocketMqConsumeFailLogRepo.findById(objDo.getId());
//        if(optional.isPresent()){
//             BeanCopyUtil.beanCopyWithIngore(objDo, optional.get(), BeanCopyUtil.getNullPropertyNames(objDo));
//             sysRocketMqConsumeFailLogRepo.save(optional.get());
//        }else{
//            throw new BusinessException(ApiCode.FAIL,"修改失败，数据不存在"+objDo.getId());
//        }
//    }

    @Override
    @Transactional
    public void updateDeleteFlag(Long id) {
        val jpaQDo = QSysRocketMqConsumeFailLogDO.sysRocketMqConsumeFailLogDO;
        Predicate predicate = jpaQDo.isNotNull();
        predicate = ExpressionUtils.and(predicate, jpaQDo.id.eq(id));
                Optional<SysRocketMqConsumeFailLogDO> optionalItem=sysRocketMqConsumeFailLogRepo.findOne(predicate);
        if(optionalItem.isPresent()) {
            SysRocketMqConsumeFailLogDO do1 = optionalItem.get();
            do1.setDeleteFlag(1);
            sysRocketMqConsumeFailLogRepo.save(do1);
        }else{
             throw new BusinessException(ApiCode.FAIL,"修改失败，数据不存在"+id);
        }
    }

    @Override
    public void sendFailMessage(SysRocketMqConsumeFailLogQueryParam param) {
        Assert.notNull(param.getConsumerKey(),"消息的key不能为空");
        Iterable<SysRocketMqConsumeFailLogDO> iterable = sysRocketMqConsumeFailLogRepo.findAll(sysRocketMqConsumeFailLogRepoProc.where(param));

        for (SysRocketMqConsumeFailLogDO sysRocketMqConsumeFailLogDO : iterable) {
            if(sysRocketMqConsumeFailLogDO.getConsumerBoby()!=null){
                String body = byteToString(sysRocketMqConsumeFailLogDO.getConsumerBoby());
//                Gson gson = new Gson();
//                MqMessageDTO mqMessageDTO = gson.fromJson(body, MqMessageDTO.class);
                //创建 Spring Message 对象
                MessageBuilder<Object> mqMessageDTOMessageBuilder = MessageBuilder.withPayload(body)
                        ;
                if(param.getConsumerTag()!=null){
                    mqMessageDTOMessageBuilder
                            .setHeader(MessageConst.PROPERTY_TAGS, param.getConsumerTag());
                }
                Message<Object> message = mqMessageDTOMessageBuilder.build();
                if(rocketMQTemplate==null){
                    throw new BusinessException("请配置RocketMQ相关配置");
                }

                String topic = sysRocketMqConsumeFailLogDO.getConsumerTopic()==null ? "cloudt-topic":sysRocketMqConsumeFailLogDO.getConsumerTopic();
                if(param.getCustomConsumerTopic()!=null){
                    topic =  param.getCustomConsumerTopic();
                }
                SendResult sendResult = rocketMQTemplate.syncSend(topic, message);
                if (!sendResult.getSendStatus().equals(SendStatus.SEND_OK)) {
                    throw new BusinessException("发送消息失败");
                }
//                cloudTMqSource.sendOutput1().send(message);
                updateDeleteFlag(sysRocketMqConsumeFailLogDO.getId());
            }
        }

    }


    @Override
    @Transactional
    public void deleteOne(Long id) {
     
      this.sysRocketMqConsumeFailLogRepo.deleteById(id) ;
      
    }
    
    @Override
    @Transactional
    public void deleteBatch(List<Long> list) {
        list.forEach(id-> sysRocketMqConsumeFailLogRepo.deleteById(id));
    }

    private static String byteToString(byte[] bytes) {
        if (null == bytes || bytes.length == 0) {
            return "";
        }
        String strContent = "";
        try {
            strContent = new String(bytes, "utf-8");
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return strContent;
    }
}


