package com.elitescloud.boot.mq.compensate.utils;

import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.mq.compensate.param.SysRocketMqConsumeLogCreateParam;
import com.elitescloud.boot.mq.compensate.service.SysRocketMqConsumeLogService;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Map;

/**
 * <p>
 * 功能说明
 * MQ消费
 * </p>
 *
 * @author roman
 * @since 2022/4/1 6:31 PM
 */
public class MQConsumeUtils {

    private SysRocketMqConsumeLogService sysRocketMqConsumeLogService;

    @Autowired
    public void setSysRocketMqConsumeLogService(SysRocketMqConsumeLogService sysRocketMqConsumeLogService) {
        this.sysRocketMqConsumeLogService = sysRocketMqConsumeLogService;
    }

    /**
     * 记录消费者消费的信息，如果根据rocketmq_keys 查看消息是多条的，则证明消息是重试或业务代码存在异常。
     *
     * @param headers 消费者获取的消息的头信息
     */
    public void recordMessage(Map headers) {
        Assert.notNull(headers, "消息头信息为null");
        String rocketmq_topic = (String) headers.get(RocketMqConstant.ROCKETMQ_TOPIC);
        String rocketmq_keys = (String) headers.get(RocketMqConstant.ROCKETMQ_KEYS);
        String rocketmq_MESSAGE_ID = (String) headers.get(RocketMqConstant.ROCKETMQ_MESSAGE_ID);
        String rocketmq_RECONSUME_TIMES = (String) headers.get(RocketMqConstant.ROCKETMQ_RECONSUME_TIMES);

        SysRocketMqConsumeLogCreateParam sysRocketMqConsumeLogDO = new SysRocketMqConsumeLogCreateParam();
        sysRocketMqConsumeLogDO.setConsumerTopic(rocketmq_topic);
        sysRocketMqConsumeLogDO.setConsumerKey(rocketmq_keys);
        sysRocketMqConsumeLogDO.setMessageId(rocketmq_MESSAGE_ID);
        sysRocketMqConsumeLogDO.setReconsumeTimes(Integer.valueOf(rocketmq_RECONSUME_TIMES));
        sysRocketMqConsumeLogDO.setId(Long.valueOf(rocketmq_keys));
        sysRocketMqConsumeLogService.createOne(sysRocketMqConsumeLogDO);
    }
//
//    public void getBean(){
//        SpringUtils
//
//    }

}
