package com.elitescloud.boot.mq.compensate.param;


import com.elitescloud.cloudt.common.annotation.Comment;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@Data
@ApiModel(value = "SysRocketMqConsumeLogUpdateParam", description = "架构补偿机制-消费记录")
public class SysRocketMqConsumeLogUpdateParam implements Serializable {
    private static final long serialVersionUID = -23585146728848698L;
    /**
    * 记录唯一ID
    */    
    @ApiModelProperty("记录唯一ID")
    private Long id;
    /**
    * 消息行号
    */    
    @ApiModelProperty("消息行号")
    private Long lineNum;

    @ApiModelProperty(value = "消息体key")
    private Integer queueId;

    @ApiModelProperty(value = "消息标识")
    private String messageId;

    @ApiModelProperty(value = "重复消费的次数")
    private Integer reconsumeTimes;

    @ApiModelProperty(value = "消息UUID")
    @Comment("消息UUID")
    private String messageUuid;
    /**
    * 消息体key
    */    
    @ApiModelProperty("消息体key")
    private String consumerKey;

    /**
    * 消费者组
    */    
    @ApiModelProperty("消费者组")
    private String consumerGroup;
    /**
    * 消费主题
    */    
    @ApiModelProperty("消费主题")
    private String consumerTopic;
    /**
    * 是否消费成功:true:成功，false:失败
    */    
    @ApiModelProperty("是否消费成功:true:成功，false:失败")
    private Boolean isSuccess;
    /**
    * 失败详情
    */    
    @ApiModelProperty("失败详情")
    private String failDetail;
    /**
    * 租户ID
    */    
    @ApiModelProperty("租户ID")
    private Long tenantId;
    /**
    * 备注
    */    
    @ApiModelProperty("备注")
    private String remark;
    /**
    * 记录创建者ID
    */    
    @ApiModelProperty("记录创建者ID")
    private Long createUserId;
    /**
    * 记录创建者
    */    
    @ApiModelProperty("记录创建者")
    private String creator;
    /**
    * 记录创建时间
    */    
    @ApiModelProperty("记录创建时间")
    private String createTime;
    /**
    * 记录最后更新者ID
    */    
    @ApiModelProperty("记录最后更新者ID")
    private Long modifyUserId;
    /**
    * 记录最后更新者
    */    
    @ApiModelProperty("记录最后更新者")
    private String updater;
    /**
    * 记录最后更新时间
    */    
    @ApiModelProperty("记录最后更新时间")
    private String modifyTime;
    /**
    * 逻辑删除，0：未删除，1：已删除
    */    
    @ApiModelProperty("逻辑删除，0：未删除，1：已删除")
    private Integer deleteFlag;
    /**
    * 锁版本
    */    
    @ApiModelProperty("锁版本")
    private Integer auditDataVersion;
    /**
    * sec_bu_id
    */    
    @ApiModelProperty("sec_bu_id")
    private Long secBuId;
    /**
    * sec_user_id
    */    
    @ApiModelProperty("sec_user_id")
    private Long secUserId;
    /**
    * sec_ou_id
    */    
    @ApiModelProperty("sec_ou_id")
    private Long secOuId;


}
