/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.mq.compensate.service.impl;

import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.boot.mq.compensate.convert.SysRocketMqConsumeFailLogConvert;
import com.elitescloud.boot.mq.compensate.model.entity.QSysRocketMqConsumeFailLogDO;
import com.elitescloud.boot.mq.compensate.model.entity.SysRocketMqConsumeFailLogDO;
import com.elitescloud.boot.mq.compensate.model.vo.SysRocketMqConsumeFailLogVO;
import com.elitescloud.boot.mq.compensate.param.SysRocketMqConsumeFailLogCreateParam;
import com.elitescloud.boot.mq.compensate.param.SysRocketMqConsumeFailLogQueryParam;
import com.elitescloud.boot.mq.compensate.repo.SysRocketMqConsumeFailLogRepo;
import com.elitescloud.boot.mq.compensate.repo.SysRocketMqConsumeFailLogRepoProc;
import com.elitescloud.boot.mq.compensate.service.SysRocketMqConsumeFailLogService;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.client.producer.SendStatus;
import org.apache.rocketmq.spring.core.RocketMQTemplate;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.messaging.Message;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.transaction.annotation.Transactional;

public class SysRocketMqConsumeFailLogServiceImpl
implements SysRocketMqConsumeFailLogService {
    private final SysRocketMqConsumeFailLogRepo sysRocketMqConsumeFailLogRepo;
    private final SysRocketMqConsumeFailLogRepoProc sysRocketMqConsumeFailLogRepoProc;
    private final RocketMQTemplate rocketMQTemplate;

    public SysRocketMqConsumeFailLogServiceImpl(SysRocketMqConsumeFailLogRepo sysRocketMqConsumeFailLogRepo, SysRocketMqConsumeFailLogRepoProc sysRocketMqConsumeFailLogRepoProc, RocketMQTemplate rocketMQTemplate) {
        this.sysRocketMqConsumeFailLogRepo = sysRocketMqConsumeFailLogRepo;
        this.sysRocketMqConsumeFailLogRepoProc = sysRocketMqConsumeFailLogRepoProc;
        this.rocketMQTemplate = rocketMQTemplate;
    }

    @Override
    @SysCodeProc
    public PagingVO<SysRocketMqConsumeFailLogVO> search(SysRocketMqConsumeFailLogQueryParam param) {
        Page ret = this.sysRocketMqConsumeFailLogRepo.findAll(this.sysRocketMqConsumeFailLogRepoProc.where(param), (Pageable)param.getPageRequest());
        List vos = ret.getContent().stream().map(SysRocketMqConsumeFailLogConvert.INSTANCE::doToVO).collect(Collectors.toList());
        vos.stream().filter(v -> v.getConsumerBoby() != null).forEach(v -> v.setConsumerBobyString(SysRocketMqConsumeFailLogServiceImpl.byteToString(v.getConsumerBoby())));
        return PagingVO.builder().total(ret.getTotalElements()).records(vos).build();
    }

    @Override
    @SysCodeProc
    public Optional<SysRocketMqConsumeFailLogVO> findCodeOne(String itemCode) {
        JPAQuery<SysRocketMqConsumeFailLogVO> jpaQuery = this.sysRocketMqConsumeFailLogRepoProc.select(null);
        QSysRocketMqConsumeFailLogDO jpaQDo = QSysRocketMqConsumeFailLogDO.sysRocketMqConsumeFailLogDO;
        SysRocketMqConsumeFailLogVO vo = (SysRocketMqConsumeFailLogVO)jpaQuery.fetchOne();
        return Optional.ofNullable(vo);
    }

    @Override
    @SysCodeProc
    public Optional<SysRocketMqConsumeFailLogVO> findIdOne(Long id) {
        return this.sysRocketMqConsumeFailLogRepo.findById(id).map(SysRocketMqConsumeFailLogConvert.INSTANCE::doToVO);
    }

    @Override
    @SysCodeProc
    public List<SysRocketMqConsumeFailLogVO> findIdBatch(List<Long> idList) {
        return this.sysRocketMqConsumeFailLogRepo.findAllById(idList).stream().map(SysRocketMqConsumeFailLogConvert.INSTANCE::doToVO).collect(Collectors.toList());
    }

    @Override
    @Transactional
    public Long createOne(SysRocketMqConsumeFailLogCreateParam param) {
        SysRocketMqConsumeFailLogDO sysRocketMqConsumeFailLogDO = SysRocketMqConsumeFailLogConvert.INSTANCE.creatParamToDo(param);
        return ((SysRocketMqConsumeFailLogDO)this.sysRocketMqConsumeFailLogRepo.save(sysRocketMqConsumeFailLogDO)).getId();
    }

    @Override
    @Transactional
    public List<Long> createBatch(List<SysRocketMqConsumeFailLogCreateParam> list) {
        List dos = list.stream().map(SysRocketMqConsumeFailLogConvert.INSTANCE::creatParamToDo).collect(Collectors.toList());
        return this.sysRocketMqConsumeFailLogRepo.saveAll(dos).stream().map(BaseModel::getId).collect(Collectors.toList());
    }

    @Override
    @Transactional
    public void updateDeleteFlag(Long id) {
        QSysRocketMqConsumeFailLogDO jpaQDo = QSysRocketMqConsumeFailLogDO.sysRocketMqConsumeFailLogDO;
        BooleanExpression predicate = jpaQDo.isNotNull();
        Optional optionalItem = this.sysRocketMqConsumeFailLogRepo.findOne((Predicate)(predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)jpaQDo.id.eq((Object)id))));
        if (!optionalItem.isPresent()) {
            throw new BusinessException(ApiCode.FAIL, "\u4fee\u6539\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728" + id);
        }
        SysRocketMqConsumeFailLogDO do1 = (SysRocketMqConsumeFailLogDO)optionalItem.get();
        do1.setDeleteFlag(1);
        this.sysRocketMqConsumeFailLogRepo.save(do1);
    }

    @Override
    public void sendFailMessage(SysRocketMqConsumeFailLogQueryParam param) {
        Assert.notNull((Object)param.getConsumerKey(), (String)"\u6d88\u606f\u7684key\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Iterable iterable = this.sysRocketMqConsumeFailLogRepo.findAll(this.sysRocketMqConsumeFailLogRepoProc.where(param));
        for (SysRocketMqConsumeFailLogDO sysRocketMqConsumeFailLogDO : iterable) {
            SendResult sendResult;
            String topic;
            if (sysRocketMqConsumeFailLogDO.getConsumerBoby() == null) continue;
            String body = SysRocketMqConsumeFailLogServiceImpl.byteToString(sysRocketMqConsumeFailLogDO.getConsumerBoby());
            MessageBuilder mqMessageDTOMessageBuilder = MessageBuilder.withPayload((Object)body);
            if (param.getConsumerTag() != null) {
                mqMessageDTOMessageBuilder.setHeader("TAGS", (Object)param.getConsumerTag());
            }
            Message message = mqMessageDTOMessageBuilder.build();
            if (this.rocketMQTemplate == null) {
                throw new BusinessException("\u8bf7\u914d\u7f6eRocketMQ\u76f8\u5173\u914d\u7f6e");
            }
            String string = topic = sysRocketMqConsumeFailLogDO.getConsumerTopic() == null ? "cloudt-topic" : sysRocketMqConsumeFailLogDO.getConsumerTopic();
            if (param.getCustomConsumerTopic() != null) {
                topic = param.getCustomConsumerTopic();
            }
            if (!(sendResult = this.rocketMQTemplate.syncSend(topic, message)).getSendStatus().equals((Object)SendStatus.SEND_OK)) {
                throw new BusinessException("\u53d1\u9001\u6d88\u606f\u5931\u8d25");
            }
            this.updateDeleteFlag(sysRocketMqConsumeFailLogDO.getId());
        }
    }

    @Override
    @Transactional
    public void deleteOne(Long id) {
        this.sysRocketMqConsumeFailLogRepo.deleteById(id);
    }

    @Override
    @Transactional
    public void deleteBatch(List<Long> list) {
        list.forEach(id -> this.sysRocketMqConsumeFailLogRepo.deleteById(id));
    }

    private static String byteToString(byte[] bytes) {
        if (null == bytes || bytes.length == 0) {
            return "";
        }
        String strContent = "";
        try {
            strContent = new String(bytes, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return strContent;
    }
}

