package com.elitescloud.boot.mq.config;

import org.springframework.boot.context.properties.ConfigurationProperties;

import java.time.Duration;
import java.util.List;
import java.util.Set;

/**
 * 属性配置.
 *
 * @author Kaiser（wang shao）
 * @date 2023/8/15
 */
@ConfigurationProperties(prefix = CloudtMqProperties.CONFIG_PREFIX)
public class CloudtMqProperties {
    public static final String CONFIG_PREFIX = "elitesland.mq";

    /**
     * 是否启用
     */
    private Boolean enabled = true;

    /**
     * 禁用的应用编码，*标识禁用所有
     */
    private Set<String> disabledApps;

    /**
     * 是否允许消息重复
     * <p>
     * 默认不允许重复，将 <b>应用编码+channel+payload</> 进行md5签名，在允许重复的间隔{@link #allowDuplicate}内如果存在相同的，就说明重复，
     * 如果需要自定义判重策略，则可实现接口{@link com.elitescloud.boot.mq.common.MessageDuplicateStrategy}并注册为bean即可
     */
    private Boolean allowDuplicate = false;

    /**
     * 允许重复的间隔
     */
    private Duration duplicateInterval = Duration.ofMinutes(10);

    /**
     * 是否允许消费
     */
    private Boolean allowConsume = true;

    /**
     * 是否持久化消息记录
     */
    private Boolean allowStorage = true;

    /**
     * topic前缀
     * <p>
     * 不同环境可设置不同的topic前缀
     */
    private String topicPrefix;

    /**
     * 消费组
     */
    private String consumerGroup;

    /**
     * 支持重试
     */
    private Boolean supportRetry = false;

    /**
     * 重试次数
     */
    private Integer retryTimes = 3;

    /**
     * 重试间隔
     */
    private List<Duration> retryIntervals = List.of(Duration.ofMinutes(10), Duration.ofMinutes(20), Duration.ofMinutes(30));

    public Boolean getEnabled() {
        return enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public Set<String> getDisabledApps() {
        return disabledApps;
    }

    public void setDisabledApps(Set<String> disabledApps) {
        this.disabledApps = disabledApps;
    }

    public Boolean getAllowDuplicate() {
        return allowDuplicate;
    }

    public void setAllowDuplicate(Boolean allowDuplicate) {
        this.allowDuplicate = allowDuplicate;
    }

    public Duration getDuplicateInterval() {
        return duplicateInterval;
    }

    public void setDuplicateInterval(Duration duplicateInterval) {
        this.duplicateInterval = duplicateInterval;
    }

    public Boolean getAllowConsume() {
        return allowConsume;
    }

    public void setAllowConsume(Boolean allowConsume) {
        this.allowConsume = allowConsume;
    }

    public Boolean getAllowStorage() {
        return allowStorage;
    }

    public void setAllowStorage(Boolean allowStorage) {
        this.allowStorage = allowStorage;
    }

    public String getTopicPrefix() {
        return topicPrefix;
    }

    public void setTopicPrefix(String topicPrefix) {
        this.topicPrefix = topicPrefix;
    }

    public String getConsumerGroup() {
        return consumerGroup;
    }

    public void setConsumerGroup(String consumerGroup) {
        this.consumerGroup = consumerGroup;
    }

    public Boolean getSupportRetry() {
        return supportRetry;
    }

    public void setSupportRetry(Boolean supportRetry) {
        this.supportRetry = supportRetry;
    }

    public Integer getRetryTimes() {
        return retryTimes;
    }

    public void setRetryTimes(Integer retryTimes) {
        this.retryTimes = retryTimes;
    }

    public List<Duration> getRetryIntervals() {
        return retryIntervals;
    }

    public void setRetryIntervals(List<Duration> retryIntervals) {
        this.retryIntervals = retryIntervals;
    }
}
