package com.elitescloud.boot.mq.common.model;

import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 消息存储对象.
 *
 * @author Kaiser（wang shao）
 * @date 2023/8/15
 */
@Data
public class StoreMessageDTO implements Serializable {
    private static final long serialVersionUID = 4868651699812466945L;

    /**
     * 消息ID
     */
    private String messageId;

    /**
     * 原始消息ID
     */
    private String businessKey;

    /**
     * 应用编码
     */
    private String appCode;

    /**
     * 渠道编码
     */
    private String channel;

    /**
     * 消息内容
     */
    private String messageContent;

    /**
     * 发送时间
     */
    private LocalDateTime sendTime;

    /**
     * 发送结束时间
     */
    private LocalDateTime finishTime;

    /**
     * 是否本地化消费
     */
    private Boolean local;

    /**
     * 是否发送成功
     */
    private Boolean success;

    /**
     * 发送失败原因
     */
    private String failReason;

    /**
     * 是否可重试发送
     */
    private Boolean retryable;
}
