package com.elitescloud.boot.mq.common;

import com.elitescloud.boot.mq.common.model.StoreMessageDTO;

/**
 * 消息持久化.
 *
 * @author Kaiser（wang shao）
 * @date 2023/8/15
 */
public interface MessageQueueStorage {

    /**
     * 保存消息
     *
     * @param messageDTO 消息信息
     */
    void saveMessage(StoreMessageDTO messageDTO);

    /**
     * 更新消息发送结果
     *
     * @param messageId  消息ID
     * @param success    是否发送成功
     * @param failReason 发送失败原因
     */
    void updateSendResult(String messageId, boolean success, String failReason);

    /**
     * 更新消息发送结果
     *
     * @param messageId  消息ID
     * @param success    是否发送成功
     * @param failReason 发送失败原因
     * @param cost       消费耗时
     */
    void updateConsumeResult(String messageId, boolean success, String failReason, long cost);
}
