package com.elitescloud.boot.mq;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 消息监听器.
 *
 * @author Kaiser（wang shao）
 * @date 2023/8/14
 */
public interface MessageQueueListener<T extends Serializable> {

    /**
     * 监听的消息渠道
     *
     * @return 消息渠道列表
     */
    @NotEmpty
    String[] channels();

    /**
     * 消费消息
     *
     * @param playload 消息内容
     */
    void onConsume(@NotBlank String channel, @NotNull T playload);
}
