package com.elitescloud.boot.mq;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 消息.
 * <p>
 * 建议消息体payload实现基础类 {@link com.elitescloud.boot.mq.common.BaseMessage}
 *
 * @author Kaiser（wang shao）
 * @date 2023/8/14
 */
public interface MessageQueueTemplate {

    /**
     * 发送消息
     * <p>
     * 如果有内部消费者，则直接内部消费，不再向外发布
     *
     * @param channel 渠道
     * @param payload 消息内容
     * @param <T>     消息类型
     */
    <T extends Serializable> void sendMessage(@NotBlank String channel, @NotNull T payload);

    /**
     * 发送消息
     * <p>
     * 如果有内部消费者，则直接内部消费，不再向外发布
     *
     * @param appCode 应用编码
     * @param channel 渠道
     * @param payload 消息内容
     * @param <T>     消息类型
     */
    <T extends Serializable> void sendMessage(String appCode, @NotBlank String channel, @NotNull T payload);

    /**
     * 发布消息
     * <p>
     * 订阅者均可消费，包括内部和外部的消费者
     *
     * @param channel 渠道
     * @param payload 消息内容
     * @param <T>     消息类型
     */
    <T extends Serializable> void publishMessage(@NotBlank String channel, @NotNull T payload);

    /**
     * 发布消息
     * <p>
     * 订阅者均可消费，包括内部和外部的消费者
     *
     * @param appCode 应用编码
     * @param channel 渠道
     * @param payload 消息内容
     * @param <T>     消息类型
     */
    <T extends Serializable> void publishMessage(String appCode, @NotBlank String channel, @NotNull T payload);
}
