package com.elitescloud.boot.mq.common;

import javax.validation.constraints.NotBlank;

/**
 * 消息重复判断策略.
 *
 * @author Kaiser（wang shao）
 * @date 2023/8/16
 */
public interface MessageDuplicateStrategy {

    /**
     * 判断是否重复
     *
     * @param appCode 应用编码
     * @param channel 消息渠道
     * @param payload 消息数据
     * @return 是否重复
     */
    boolean isDuplicate(String appCode, @NotBlank String channel, Object payload);
}
