package com.elitescloud.boot.mq.common.model;

import com.elitescloud.boot.task.retry.RetryTask;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.time.LocalDateTime;

/**
 * 重试消息信息.
 *
 * @author Kaiser（wang shao）
 * @date 2023/8/28
 */
@Data
public class RetryMessageDTO extends RetryTask {
    private static final long serialVersionUID = 2223877142266257235L;

    /**
     * 所属租户ID
     */
    private Long sysTenantId;

    /**
     * 渠道编码
     */
    @NotBlank
    private String channel;

    /**
     * 消息内容
     */
    @NotBlank
    private String messageContent;

    /**
     * 上次发送时间
     */
    private LocalDateTime sendTime;
}
