package com.elitescloud.boot.mq.common;

/**
 * 消息队列常量.
 *
 * @author Kaiser（wang shao）
 * @date 2023/8/14
 */
public interface MessageQueueConstant {

    /**
     * 消息topic
     */
    String CLOUDT_MESSAGE_CHANNEL = "cloudt_message_delegate_channel";

    /**
     * 生产者binding
     */
    String CLOUDT_MESSAGE_CHANNEL_OUTPUT = CLOUDT_MESSAGE_CHANNEL + "_output";

    /**
     * 消费者binding
     */
    String CLOUDT_MESSAGE_CHANNEL_INPUT = CLOUDT_MESSAGE_CHANNEL + "_input";

    /**
     * 消费者组名称前缀
     */
    String CLOUDT_MESSAGE_CHANNEL_INPUT_GROUP_PREFIX = "cloudt_message_consumer_";

    /**
     * 消息的原始渠道
     */
    String HEADER_CLOUDT_MESSAGE_CHANNEL_ORIGINAL = "cloudt_message_original_channel";

    /**
     * 消息ID
     */
    String HEADER_CLOUDT_MESSAGE_ID = "cloudt_message_id";

    /**
     * 原始消息ID
     */
    String HEADER_CLOUDT_MESSAGE_ID_ORIGINAL = "cloudt_original_message_id";

    /**
     * rocketMQ keys
     */
    String HEADER_KEYS = "KEYS";
}
