/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.mq.config.support;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.crypto.digest.MD5;
import com.elitescloud.boot.mq.MessageQueueTemplate;
import com.elitescloud.boot.mq.common.BaseMessage;
import com.elitescloud.boot.mq.common.MessageDuplicateStrategy;
import com.elitescloud.boot.mq.common.MessageQueueStorage;
import com.elitescloud.boot.mq.common.model.StoreMessageDTO;
import com.elitescloud.boot.mq.config.CloudtMqProperties;
import com.elitescloud.boot.mq.config.support.MessageCommonSupport;
import com.elitescloud.boot.redis.util.RedisUtils;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.stream.annotation.Output;
import org.springframework.core.task.TaskExecutor;
import org.springframework.messaging.MessageChannel;

public class DefaultMessageQueueTemplate
implements MessageQueueTemplate {
    private static final Logger log = LoggerFactory.getLogger(DefaultMessageQueueTemplate.class);
    private final MessageCommonSupport messageCommonSupport;
    private final TaskExecutor taskExecutor;
    private final CloudtMqProperties mqProperties;
    private final RedisUtils redisUtils;
    private List<MessageQueueStorage> queueStorageList = Collections.emptyList();
    private List<MessageDuplicateStrategy> duplicateStrategyList = Collections.emptyList();
    private MessageChannel messageChannel;

    public DefaultMessageQueueTemplate(TaskExecutor taskExecutor, MessageCommonSupport messageCommonSupport, CloudtMqProperties mqProperties, RedisUtils redisUtils) {
        this.messageCommonSupport = messageCommonSupport;
        this.taskExecutor = taskExecutor;
        this.mqProperties = mqProperties;
        this.redisUtils = redisUtils;
    }

    @Override
    public <T extends Serializable> void sendMessage(String channel, T payload) {
        this.sendMessage(null, channel, payload);
    }

    @Override
    public <T extends Serializable> void sendMessage(String appCode, String channel, T payload) {
        Assert.notBlank((CharSequence)channel, (String)"\u6d88\u606f\u6e20\u9053\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull(payload, (String)"\u6d88\u606f\u4f53\u4e3a\u7a7a", (Object[])new Object[0]);
        LocalDateTime startTime = LocalDateTime.now();
        String messageId = this.messageCommonSupport.generateMessageId();
        if (!this.canSend(appCode)) {
            log.info("{}\u7684\u6d88\u606f\u53d1\u9001\u5df2\u7981\u7528", (Object)appCode);
            this.storageRecord(appCode, channel, messageId, payload, startTime, true, false, false, "\u5df2\u7981\u7528\u8be5\u5e94\u7528\u53d1\u9001");
            return;
        }
        List listeners = this.messageCommonSupport.getListenerMap().getOrDefault(channel, Collections.emptyList());
        if (listeners.isEmpty()) {
            this.executeSend(() -> this.messageCommonSupport.publishMqMessage(this.messageChannel, channel, messageId, payload), appCode, channel, messageId, payload, false, startTime);
            return;
        }
        log.info("\u672c\u5730\u6d88\u606f\uff1a{}, \u6d88\u8d39\u8005\uff1a{}", (Object)channel, (Object)listeners.size());
        this.executeSend(() -> this.taskExecutor.execute(() -> {
            for (MessageCommonSupport.MessageQueueListenerWrapper listener : listeners) {
                try {
                    listener.getMessageQueueListener().onConsume(channel, payload);
                }
                catch (Throwable e) {
                    log.error("{}\u6d88\u8d39\u6d88\u606f\u5f02\u5e38\uff1a", (Object)listener.getClass().getName(), (Object)e);
                }
            }
        }), appCode, channel, messageId, payload, true, startTime);
    }

    @Override
    public <T extends Serializable> void publishMessage(String channel, T payload) {
        this.publishMessage(null, channel, payload);
    }

    @Override
    public <T extends Serializable> void publishMessage(String appCode, String channel, T payload) {
        Assert.notBlank((CharSequence)channel, (String)"\u6d88\u606f\u6e20\u9053\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull(payload, (String)"\u6d88\u606f\u4f53\u4e3a\u7a7a", (Object[])new Object[0]);
        LocalDateTime startTime = LocalDateTime.now();
        String messageId = this.messageCommonSupport.generateMessageId();
        if (!this.canSend(appCode)) {
            log.info("{}\u7684\u6d88\u606f\u53d1\u9001\u5df2\u7981\u7528", (Object)appCode);
            this.storageRecord(appCode, channel, messageId, payload, startTime, false, false, false, "\u5df2\u7981\u7528\u8be5\u5e94\u7528\u53d1\u9001");
            return;
        }
        this.executeSend(() -> this.messageCommonSupport.publishMqMessage(this.messageChannel, channel, messageId, payload), appCode, channel, messageId, payload, false, startTime);
    }

    @Autowired
    @Output(value="cloudt_message_delegate_channel_output")
    public void setMessageChannel(MessageChannel messageChannel) {
        this.messageChannel = messageChannel;
    }

    public void setQueueStorageList(List<MessageQueueStorage> queueStorageList) {
        this.queueStorageList = (List)ObjectUtil.defaultIfNull(queueStorageList, Collections.emptyList());
    }

    public void setDuplicateStrategyList(List<MessageDuplicateStrategy> duplicateStrategyList) {
        this.duplicateStrategyList = (List)ObjectUtil.defaultIfNull(duplicateStrategyList, Collections.emptyList());
    }

    private boolean canSend(String appCode) {
        if (CharSequenceUtil.isBlank((CharSequence)appCode)) {
            return true;
        }
        Set<String> apps = this.mqProperties.getDisabledApps();
        if (CollUtil.isEmpty(apps) || apps.contains("*")) {
            return true;
        }
        return !apps.contains(appCode);
    }

    private void executeSend(Runnable sendThread, String appCode, String channel, String messageId, Object payload, boolean local, LocalDateTime startTime) {
        if (this.isDuplicate(appCode, channel, payload)) {
            this.storageRecord(appCode, channel, messageId, payload, startTime, local, false, false, "\u6d88\u606f\u5df2\u91cd\u590d");
            return;
        }
        this.storageRecord(appCode, channel, messageId, payload, startTime, local, local, true, null);
        Throwable exp = null;
        long start = System.currentTimeMillis();
        try {
            sendThread.run();
        }
        catch (Throwable e) {
            exp = e;
            throw e;
        }
        finally {
            this.updateSendResult(messageId, local, exp, System.currentTimeMillis() - start);
        }
    }

    private boolean isDuplicate(String appCode, String channel, Object payload) {
        if (Boolean.TRUE.equals(this.mqProperties.getAllowDuplicate())) {
            return false;
        }
        if (!this.duplicateStrategyList.isEmpty()) {
            for (MessageDuplicateStrategy messageDuplicateStrategy : this.duplicateStrategyList) {
                if (!messageDuplicateStrategy.isDuplicate(appCode, channel, payload)) continue;
                log.info("\u81ea\u5b9a\u4e49\u6d88\u606f\u5224\u91cd\u7b56\u7565\u5224\u65ad\u5df2\u91cd\u590d\uff1a{}\uff0c{}", (Object)appCode, (Object)channel);
                return true;
            }
            return false;
        }
        String digest = null;
        try {
            String txt = appCode + "&" + channel + "&" + this.messageCommonSupport.messageToString(payload);
            digest = MD5.create().digestHex(txt, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            throw new IllegalStateException("\u5224\u65ad\u6d88\u606f\u662f\u5426\u91cd\u590d\u5f02\u5e38", e);
        }
        Object obj = this.redisUtils.get(digest);
        if (obj != null) {
            log.info("\u6d88\u606f\u5df2\u91cd\u590d\uff1a{}\uff0c{}", (Object)appCode, (Object)channel);
            return true;
        }
        this.redisUtils.set(digest, (Object)"true", this.mqProperties.getDuplicateInterval().toSeconds(), TimeUnit.SECONDS);
        return false;
    }

    private String storageRecord(String appCode, String channel, String messageId, Object payload, LocalDateTime sendTime, boolean local, boolean success, boolean retry, String failReason) {
        if (Boolean.FALSE.equals(this.mqProperties.getAllowStorage())) {
            return null;
        }
        if (this.queueStorageList.isEmpty()) {
            return null;
        }
        LocalDateTime endTime = LocalDateTime.now();
        StoreMessageDTO messageDTO = new StoreMessageDTO();
        messageDTO.setMessageId(messageId);
        messageDTO.setAppCode(appCode);
        messageDTO.setChannel(channel);
        messageDTO.setMessageContent(this.messageCommonSupport.messageToString(payload));
        if (payload instanceof BaseMessage) {
            messageDTO.setBusinessKey(((BaseMessage)payload).getBusinessKey());
        }
        messageDTO.setSendTime(sendTime);
        messageDTO.setFinishTime(endTime);
        messageDTO.setLocal(local);
        messageDTO.setSuccess(success);
        messageDTO.setFailReason(failReason);
        messageDTO.setRetryable(retry);
        for (MessageQueueStorage messageQueueStorage : this.queueStorageList) {
            try {
                messageQueueStorage.saveMessage(messageDTO);
            }
            catch (Throwable e) {
                log.error("\u6301\u4e45\u5316\u6d88\u606f\u53d1\u9001\u8bb0\u5f55\u5f02\u5e38\uff1a", e);
            }
        }
        return messageId;
    }

    public void updateSendResult(String messageId, boolean local, Throwable e, Long costTime) {
        if (CharSequenceUtil.isBlank((CharSequence)messageId)) {
            return;
        }
        String failReason = e == null ? null : e.getMessage();
        CompletableFuture.runAsync(() -> {
            if (local) {
                for (MessageQueueStorage messageQueueStorage : this.queueStorageList) {
                    try {
                        messageQueueStorage.updateConsumeResult(messageId, e == null, failReason, (Long)ObjectUtil.defaultIfNull((Object)costTime, (Object)0L));
                    }
                    catch (Throwable t) {
                        log.error("\u66f4\u65b0\u6d88\u8d39\u7ed3\u679c\u5f02\u5e38\uff1a", e);
                    }
                }
                return;
            }
            for (MessageQueueStorage messageQueueStorage : this.queueStorageList) {
                try {
                    messageQueueStorage.updateSendResult(messageId, e == null, failReason);
                }
                catch (Throwable t) {
                    log.error("\u66f4\u65b0\u53d1\u9001\u7ed3\u679c\u5f02\u5e38\uff1a", e);
                }
            }
        }, (Executor)this.taskExecutor).whenComplete((res, exp) -> {
            if (exp != null) {
                log.error("\u66f4\u65b0\u6d88\u606f\u7ed3\u679c\u5f02\u5e38\uff1a{}", (Object)messageId, exp);
            }
        });
    }
}

