/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.mq.config;

import com.elitescloud.boot.mq.MessageQueueTemplate;
import com.elitescloud.boot.mq.common.MessageDuplicateStrategy;
import com.elitescloud.boot.mq.common.MessageQueueStorage;
import com.elitescloud.boot.mq.common.MessageRetryProvider;
import com.elitescloud.boot.mq.common.MessageRetryService;
import com.elitescloud.boot.mq.config.CloudtMqProperties;
import com.elitescloud.boot.mq.config.support.CloudtMessageChannel;
import com.elitescloud.boot.mq.config.support.DefaultMessageQueueTemplate;
import com.elitescloud.boot.mq.config.support.MessageCommonSupport;
import com.elitescloud.boot.mq.config.support.MessageQueueConsumerDelegate;
import com.elitescloud.boot.mq.config.support.MessageRetryServiceImpl;
import com.elitescloud.boot.mq.config.support.storage.EmptyMessageQueueStorage;
import com.elitescloud.boot.mq.config.support.storage.LogMessageQueueStorage;
import com.elitescloud.boot.mq.config.support.storage.MqMessageQueueStorage;
import com.elitescloud.boot.provider.TenantDataIsolateProvider;
import com.elitescloud.boot.redis.util.RedisUtils;
import java.util.List;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.stream.annotation.EnableBinding;
import org.springframework.context.annotation.Bean;
import org.springframework.core.task.TaskExecutor;

@EnableBinding(value={CloudtMessageChannel.class})
@EnableConfigurationProperties(value={CloudtMqProperties.class})
public class CloudtMqAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(CloudtMqAutoConfiguration.class);
    private final CloudtMqProperties mqProperties;

    public CloudtMqAutoConfiguration(CloudtMqProperties mqProperties) {
        logger.info("MQ storageType\uff1a{}", (Object)mqProperties.getStorageType());
        this.mqProperties = mqProperties;
    }

    @Bean
    public MessageCommonSupport messageCommonSupport() {
        return new MessageCommonSupport(this.mqProperties);
    }

    @Bean
    @ConditionalOnProperty(prefix="elitesland.mq", name={"storage-type"}, havingValue="empty")
    public EmptyMessageQueueStorage emptyMessageQueueStorage() {
        return new EmptyMessageQueueStorage();
    }

    @Bean
    @ConditionalOnProperty(prefix="elitesland.mq", name={"storage-type"}, havingValue="log")
    public LogMessageQueueStorage logMessageQueueStorage() {
        return new LogMessageQueueStorage();
    }

    @Bean
    @ConditionalOnProperty(prefix="elitesland.mq", name={"storage-type"}, havingValue="mq")
    public MqMessageQueueStorage mqMessageQueueStorage(MessageCommonSupport messageCommonSupport) {
        return new MqMessageQueueStorage(messageCommonSupport);
    }

    @Bean
    public MessageQueueTemplate messageQueueTemplateDefault(TaskExecutor taskExecutor, MessageCommonSupport messageCommonSupport, RedisUtils redisUtils, List<MessageQueueStorage> queueStorageList, List<MessageDuplicateStrategy> duplicateStrategyList) {
        DefaultMessageQueueTemplate template = new DefaultMessageQueueTemplate(taskExecutor, messageCommonSupport, this.mqProperties, redisUtils);
        template.setQueueStorageList(queueStorageList);
        template.setDuplicateStrategyList(duplicateStrategyList);
        return template;
    }

    @Bean
    @ConditionalOnProperty(prefix="elitesland.mq", name={"allow-consume"}, havingValue="true", matchIfMissing=true)
    public MessageQueueConsumerDelegate messageQueueConsumerDelegate(MessageCommonSupport messageCommonSupport, List<MessageQueueStorage> queueStorageList) {
        MessageQueueConsumerDelegate consumerDelegate = new MessageQueueConsumerDelegate(messageCommonSupport, this.mqProperties);
        consumerDelegate.setQueueStorageList(queueStorageList);
        return consumerDelegate;
    }

    @Bean
    @ConditionalOnBean(value={MessageRetryProvider.class})
    @ConditionalOnProperty(prefix="elitesland.mq", name={"support-retry"}, havingValue="true")
    public MessageRetryService messageRetryService(MessageCommonSupport messageCommonSupport, RedissonClient redissonClient, MessageRetryProvider messageRetryProvider, TenantDataIsolateProvider tenantDataIsolateProvider) {
        return new MessageRetryServiceImpl(messageCommonSupport, redissonClient, messageRetryProvider, this.mqProperties, tenantDataIsolateProvider);
    }
}

