/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.mq.config;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.common.CloudtBootLoggerFactory;
import com.elitescloud.boot.mq.MessageQueueTemplate;
import com.elitescloud.boot.mq.common.MessageDuplicateStrategy;
import com.elitescloud.boot.mq.common.MessageQueueStorage;
import com.elitescloud.boot.mq.common.MessageRetryProvider;
import com.elitescloud.boot.mq.common.MessageRetryService;
import com.elitescloud.boot.mq.config.CloudtMqProperties;
import com.elitescloud.boot.mq.config.support.DefaultMessageQueueTemplate;
import com.elitescloud.boot.mq.config.support.MessageRetryServiceImpl;
import com.elitescloud.boot.mq.config.support.queue.MqProvider;
import com.elitescloud.boot.mq.config.support.queue.messagechannel.CloudtBindableProxyFactory;
import com.elitescloud.boot.mq.config.support.queue.messagechannel.MessageChannelMqProvider;
import com.elitescloud.boot.mq.config.support.queue.redisstream.RedisStreamMqProvider;
import com.elitescloud.boot.mq.config.support.storage.EmptyMessageQueueStorage;
import com.elitescloud.boot.mq.config.support.storage.LogMessageQueueStorage;
import com.elitescloud.boot.mq.config.support.storage.MqMessageQueueStorage;
import com.elitescloud.boot.provider.TenantClientProvider;
import com.elitescloud.boot.provider.TenantDataIsolateProvider;
import com.elitescloud.boot.redis.util.RedisUtils;
import com.elitescloud.boot.wrapper.RedisWrapper;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.stream.function.StreamBridge;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.lang.NonNull;

@EnableConfigurationProperties(value={CloudtMqProperties.class})
@Import(value={MessageChannelConfig.class, RedisStreamConfig.class})
@ConditionalOnProperty(prefix="elitesland.mq", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class CloudtMqAutoConfiguration {
    private static final Logger logger = CloudtBootLoggerFactory.MQ.getLogger(CloudtMqAutoConfiguration.class);
    private final CloudtMqProperties mqProperties;

    public CloudtMqAutoConfiguration(CloudtMqProperties mqProperties) {
        logger.info("MQ queueType\uff1a{}\uff0c storageType\uff1a{}", (Object)mqProperties.getQueueType(), (Object)mqProperties.getStorageType());
        this.mqProperties = mqProperties;
    }

    @Bean
    @ConditionalOnProperty(prefix="elitesland.mq", name={"storage-type"}, havingValue="empty")
    public EmptyMessageQueueStorage emptyMessageQueueStorage() {
        return new EmptyMessageQueueStorage();
    }

    @Bean
    @ConditionalOnProperty(prefix="elitesland.mq", name={"storage-type"}, havingValue="log")
    public LogMessageQueueStorage logMessageQueueStorage() {
        return new LogMessageQueueStorage();
    }

    @Bean
    @ConditionalOnProperty(prefix="elitesland.mq", name={"storage-type"}, havingValue="mq")
    public MqMessageQueueStorage mqMessageQueueStorage(MqProvider mqProvider) {
        return new MqMessageQueueStorage(mqProvider);
    }

    @Bean
    public MessageQueueTemplate messageQueueTemplateDefault(MqProvider mqProvider, RedisUtils redisUtils, List<MessageQueueStorage> queueStorageList, List<MessageDuplicateStrategy> duplicateStrategyList) {
        DefaultMessageQueueTemplate template = new DefaultMessageQueueTemplate(mqProvider, this.mqProperties, redisUtils);
        template.setQueueStorageList(queueStorageList);
        template.setDuplicateStrategyList(duplicateStrategyList);
        return template;
    }

    @Bean
    @ConditionalOnBean(value={MessageRetryProvider.class})
    @ConditionalOnProperty(prefix="elitesland.mq", name={"support-retry"}, havingValue="true")
    public MessageRetryService messageRetryService(MqProvider mqProvider, MessageRetryProvider messageRetryProvider, TenantDataIsolateProvider tenantDataIsolateProvider) {
        return new MessageRetryServiceImpl(mqProvider, messageRetryProvider, this.mqProperties, tenantDataIsolateProvider);
    }

    @ConditionalOnProperty(prefix="elitesland.mq", name={"queue-type"}, havingValue="REDIS_STREAM")
    static class RedisStreamConfig {
        @Value(value="${spring.application.name:#{''}}")
        private String applicationName;
        private final CloudtMqProperties properties;

        public RedisStreamConfig(CloudtMqProperties properties) {
            this.properties = properties;
        }

        @Bean
        public RedisStreamMqProvider redisStreamMqProvider(List<MessageQueueStorage> queueStorageList, RedisUtils redisUtils, RedisWrapper redisWrapper, TenantClientProvider tenantClientProvider, TenantDataIsolateProvider tenantDataIsolateProvider) {
            return new RedisStreamMqProvider(this.properties, queueStorageList, redisUtils, redisWrapper, tenantClientProvider, tenantDataIsolateProvider, this.applicationName);
        }
    }

    @ConditionalOnProperty(prefix="elitesland.mq", name={"queue-type"}, havingValue="MESSAGE_CHANNEL", matchIfMissing=true)
    static class MessageChannelConfig
    implements ApplicationContextAware,
    InitializingBean {
        @Value(value="${spring.application.name::#{'unknown'}}")
        private String applicationName;
        private final CloudtMqProperties properties;
        private ApplicationContext applicationContext;

        public MessageChannelConfig(CloudtMqProperties properties) {
            this.properties = properties;
        }

        @Bean
        public MessageChannelMqProvider messageChannelMqProvider(StreamBridge streamBridge, List<MessageQueueStorage> queueStorageList, TenantClientProvider tenantClientProvider) {
            return new MessageChannelMqProvider(this.properties, queueStorageList, tenantClientProvider, streamBridge, this.applicationName);
        }

        public void setApplicationContext(@NonNull ApplicationContext applicationContext) throws BeansException {
            this.applicationContext = applicationContext;
        }

        public void afterPropertiesSet() throws Exception {
            if (Boolean.FALSE.equals(this.properties.getEnabled())) {
                return;
            }
            BeanDefinition beanDefinition = this.createBindingBeanDefinition();
            DefaultListableBeanFactory beanFactory = (DefaultListableBeanFactory)this.applicationContext.getAutowireCapableBeanFactory();
            beanFactory.registerBeanDefinition("cloudtMqDelegate", beanDefinition);
        }

        private BeanDefinition createBindingBeanDefinition() {
            ArrayList<CallSite> inputNames = new ArrayList<CallSite>();
            String topicName = CharSequenceUtil.blankToDefault((CharSequence)this.properties.getTopicDefault(), (String)"cloudt_message_delegate_channel");
            String topicInput = topicName + "_input";
            inputNames.add((CallSite)((Object)topicInput));
            if (CollUtil.isNotEmpty(this.properties.getTopicMappings())) {
                for (CloudtMqProperties.TopicMapping topicMapping : this.properties.getTopicMappings()) {
                    topicInput = topicMapping.getTopic() + "_input";
                    if (inputNames.contains(topicInput)) continue;
                    inputNames.add((CallSite)((Object)topicInput));
                }
            }
            RootBeanDefinition beanDefinition = new RootBeanDefinition(CloudtBindableProxyFactory.class);
            beanDefinition.getConstructorArgumentValues().addGenericArgumentValue(CloudtMqAutoConfiguration.class);
            beanDefinition.getConstructorArgumentValues().addGenericArgumentValue(inputNames);
            return beanDefinition;
        }
    }
}

