/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.mq.config;

import com.elitescloud.boot.mq.config.CloudtMqProperties;
import com.elitescloud.boot.mq.config.support.CloudtRocketMQTemplate;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.spring.autoconfigure.RocketMQAutoConfiguration;
import org.apache.rocketmq.spring.core.RocketMQTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;

@ConditionalOnClass(value={RocketMQAutoConfiguration.class})
@AutoConfigureBefore(value={RocketMQAutoConfiguration.class})
@ConditionalOnProperty(prefix="elitesland.mq", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class CloudtRocketMqAutoConfiguration {
    private final CloudtMqProperties properties;

    public CloudtRocketMqAutoConfiguration(CloudtMqProperties properties) {
        this.properties = properties;
    }

    @Bean(destroyMethod="destroy")
    public RocketMQTemplate customRocketMQTemplate(@Autowired(required=false) DefaultMQProducer mqProducer) {
        CloudtRocketMQTemplate rocketMQTemplate = new CloudtRocketMQTemplate(mqProducer, this.properties);
        if (mqProducer == null) {
            mqProducer = new DefaultMQProducer();
        }
        rocketMQTemplate.setProducer(mqProducer);
        return rocketMQTemplate;
    }
}

