/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.mq.config.support.queue;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.lang.UUID;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.RandomUtil;
import com.elitescloud.boot.SpringContextHolder;
import com.elitescloud.boot.base.AbstractLogTraceHandler;
import com.elitescloud.boot.common.CloudtBootLoggerFactory;
import com.elitescloud.boot.constant.TenantConstant;
import com.elitescloud.boot.context.TenantContextHolder;
import com.elitescloud.boot.mq.MessageQueueListener;
import com.elitescloud.boot.mq.common.MessageQueueStorage;
import com.elitescloud.boot.mq.config.CloudtMqProperties;
import com.elitescloud.boot.mq.config.support.queue.MqProvider;
import com.elitescloud.boot.provider.TenantClientProvider;
import com.elitescloud.boot.util.ArrayUtil;
import com.elitescloud.boot.util.ClassUtil;
import com.elitescloud.boot.util.ExceptionsUtil;
import com.elitescloud.boot.util.JSONUtil;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;

public abstract class AbstractMqProvider
extends AbstractLogTraceHandler
implements MqProvider,
ApplicationRunner {
    private static final Logger logger = CloudtBootLoggerFactory.MQ.getLogger(AbstractMqProvider.class);
    private final CloudtMqProperties properties;
    private final List<MessageQueueStorage> queueStorageList;
    private final TenantClientProvider tenantClientProvider;
    private Map<String, List<MessageQueueListenerWrapper>> listenerMap;

    public AbstractMqProvider(CloudtMqProperties properties, List<MessageQueueStorage> queueStorageList, TenantClientProvider tenantClientProvider, String traceIdPrefix) {
        super(traceIdPrefix);
        this.properties = properties;
        this.queueStorageList = queueStorageList;
        this.tenantClientProvider = tenantClientProvider;
    }

    protected abstract void sendMessage(String var1, String var2, long var3, String var5);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void consumeMessage(String channel, String messageId, long tenantId, String payload) {
        if (Boolean.FALSE.equals(this.properties.getAllowConsume())) {
            logger.info("MQ\u6d88\u8d39\u5df2\u7981\u7528");
            return;
        }
        if (CharSequenceUtil.isBlank((CharSequence)channel)) {
            logger.info("\u6d88\u606f\u7684channel\uff0c\u5ffd\u7565\u6d88\u606f");
            return;
        }
        if (CharSequenceUtil.isBlank((CharSequence)payload)) {
            logger.error("\u6d88\u606f\u4f53\u4e3a\u7a7a\uff0c\u5ffd\u7565\u6d88\u606f");
            return;
        }
        List<MessageQueueListenerWrapper> listeners = this.getListenerMap().get(channel);
        if (CollUtil.isEmpty(listeners)) {
            logger.info("No suitable channel was found, so it was discarded: {}", (Object)messageId);
            return;
        }
        logger.info("received MQ\uff1amessageId-{}, tenantId-{}, channel-{}", new Object[]{messageId, tenantId, channel});
        Throwable exp = null;
        long start = System.currentTimeMillis();
        SysTenantDTO tenant = this.tenantClientProvider.getTenant(Long.valueOf(tenantId));
        if (tenant != null) {
            TenantContextHolder.setCurrentTenant((SysTenantDTO)tenant);
        }
        try {
            for (MessageQueueListenerWrapper listener : listeners) {
                logger.info("{}\u5f00\u59cb\u6d88\u8d39\u6d88\u606f\uff1a{}", (Object)listener.getClass().getName(), (Object)messageId);
                try {
                    Serializable msg = (Serializable)this.deserializationMessage(payload, listener.getMessageType());
                    listener.getMessageQueueListener().onConsume(channel, msg);
                    exp = null;
                }
                catch (Throwable e) {
                    logger.error("\u6d88\u8d39\u8005{}\u6d88\u8d39\u6d88\u606f{}\u5f02\u5e38\uff1a", new Object[]{ClassUtil.getTargetClass((Object)listener).getName(), payload, e});
                    exp = e;
                }
            }
        }
        finally {
            TenantContextHolder.clearCurrentTenant();
        }
        long costTime = System.currentTimeMillis() - start;
        this.updateConsumeResult(messageId, costTime, exp);
    }

    @Override
    public String generateMessageId() {
        return UUID.fastUUID().toString(true) + ":" + RandomUtil.randomString((int)6);
    }

    @Override
    public <T extends Serializable> String serializeMessage(T payload) {
        return JSONUtil.toJsonString(payload, (boolean)true, () -> "\u6d88\u606f\u5e8f\u5217\u5316\u5f02\u5e38");
    }

    @Override
    public <T extends Serializable> void publishMessage(String channel, String messageId, T payload) {
        Assert.notBlank((CharSequence)channel, (String)"\u6d88\u606f\u6e20\u9053\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notBlank((CharSequence)messageId, (String)"\u6d88\u606fID\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull(payload, (String)"\u53d1\u5e03\u6d88\u606f\u4e3a\u7a7a", (Object[])new Object[0]);
        String payloadStr = this.serializeMessage(payload);
        SysTenantDTO tenant = this.tenantClientProvider.getSessionTenant();
        Long tenantId = tenant == null ? TenantConstant.DEFAULT_TENANT_ID : tenant.getId();
        logger.info("send MQ\uff1amessageId-{}, tenantId-{}", (Object)messageId, (Object)tenantId);
        this.sendMessage(channel, messageId, tenantId, payloadStr);
    }

    @Override
    public List<MessageQueueListener<? extends Serializable>> getListeners(String channel) {
        Assert.notBlank((CharSequence)channel, (String)"\u6d88\u606f\u6e20\u9053\u4e3a\u7a7a", (Object[])new Object[0]);
        Map<String, List<MessageQueueListenerWrapper>> listenersAll = this.getListenerMap();
        if (listenersAll.isEmpty()) {
            return Collections.emptyList();
        }
        List<MessageQueueListenerWrapper> channelListeners = listenersAll.get(channel);
        if (CollUtil.isEmpty(channelListeners)) {
            return Collections.emptyList();
        }
        return channelListeners.stream().map(MessageQueueListenerWrapper::getMessageQueueListener).collect(Collectors.toList());
    }

    @Override
    public List<Map<String, List<String>>> getAllListeners() {
        Map<String, List<MessageQueueListenerWrapper>> listenersAll = this.getListenerMap();
        if (listenersAll.isEmpty()) {
            return Collections.emptyList();
        }
        return listenersAll.entrySet().stream().map(entry -> {
            String channel = (String)entry.getKey();
            List listeners = (List)entry.getValue();
            return Map.of(channel, listeners.stream().map(MessageQueueListenerWrapper::getMessageQueueListener).map(t -> ClassUtil.getTargetClass((Object)t).getName()).collect(Collectors.toList()));
        }).collect(Collectors.toList());
    }

    public void run(ApplicationArguments args) throws Exception {
        if (this.properties.getInitListenerLazy().booleanValue()) {
            return;
        }
        Map<String, List<MessageQueueListenerWrapper>> listenerMap = this.getListenerMap();
        logger.info("MQ Listener\uff1a{}", (Object)String.join((CharSequence)",", listenerMap.keySet()));
    }

    private Map<String, List<MessageQueueListenerWrapper>> getListenerMap() {
        if (this.listenerMap == null) {
            this.listenerMap = this.initMessageQueueListener(SpringContextHolder.getObjectProvider(MessageQueueListener.class).stream().collect(Collectors.toList()));
        }
        return this.listenerMap;
    }

    private void updateConsumeResult(String messageId, long costTime, Throwable exp) {
        if (CollUtil.isEmpty(this.queueStorageList)) {
            return;
        }
        if (CharSequenceUtil.isBlank((CharSequence)messageId)) {
            logger.warn("\u6d88\u606fID\u4e3a\u7a7a\uff0c\u5ffd\u7565\u66f4\u65b0\u6d88\u8d39\u7ed3\u679c");
            return;
        }
        boolean success = exp == null;
        try {
            String expMsg = exp == null ? null : ExceptionsUtil.stackTraceAllToString((Throwable)exp);
            for (MessageQueueStorage storage : this.queueStorageList) {
                storage.updateConsumeResult(messageId, success, expMsg, costTime);
            }
        }
        catch (Exception e) {
            logger.error("\u66f4\u65b0\u6d88\u8d39\u7ed3\u679c\u5f02\u5e38\uff1a{}", (Object)messageId, (Object)e);
        }
    }

    private <T> T deserializationMessage(String message, Class<T> clazz) {
        return (T)JSONUtil.json2Obj((String)message, clazz, (boolean)true, () -> "\u6d88\u606f\u53cd\u5e8f\u5217\u5316\u5f02\u5e38");
    }

    private Map<String, List<MessageQueueListenerWrapper>> initMessageQueueListener(List<MessageQueueListener> listenerList) {
        if (CollUtil.isEmpty(listenerList)) {
            return Collections.emptyMap();
        }
        HashMap<String, List<MessageQueueListenerWrapper>> initListenerMap = new HashMap<String, List<MessageQueueListenerWrapper>>();
        for (MessageQueueListener listener : listenerList) {
            Assert.notEmpty((Object[])listener.channels(), (String)(listener.getClass().getName() + "\u4e2d\u6e20\u9053\u672a\u914d\u7f6e"), (Object[])new Object[0]);
            for (String channel : listener.channels()) {
                initListenerMap.computeIfAbsent(channel, c -> new ArrayList(8)).add(new MessageQueueListenerWrapper(listener));
            }
        }
        return initListenerMap;
    }

    static class MessageQueueListenerWrapper {
        private final MessageQueueListener<?> messageQueueListener;
        private Class<?> messageType;

        public MessageQueueListenerWrapper(MessageQueueListener<?> messageQueueListener) {
            this.messageQueueListener = messageQueueListener;
            this.init();
        }

        public MessageQueueListener<? extends Serializable> getMessageQueueListener() {
            return this.messageQueueListener;
        }

        public Class<?> getMessageType() {
            return this.messageType;
        }

        private void init() {
            this.messageType = this.obtainMessageType();
        }

        private Class<?> obtainMessageType() {
            Object[] typeArguments = ClassUtil.getTypeArguments(this.messageQueueListener, MessageQueueListener.class);
            if (ArrayUtil.isNotEmpty((Object[])typeArguments)) {
                Object temp = typeArguments[0];
                if (temp instanceof Class) {
                    return (Class)temp;
                }
                throw new IllegalStateException(this.messageQueueListener.getClass().getName() + "\u7684\u6d88\u606f\u7c7b\u578b\u4e0d\u652f\u6301");
            }
            throw new IllegalStateException(this.messageQueueListener.getClass().getName() + "\u7684\u6d88\u606f\u7c7b\u578b\u4e3a\u7a7a\u6216\u4e0d\u652f\u6301");
        }
    }
}

