/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.mq.config.support.storage;

import com.elitescloud.boot.common.CloudtBootLoggerFactory;
import com.elitescloud.boot.mq.common.MessageQueueStorage;
import com.elitescloud.boot.mq.common.model.StoreMessageDTO;
import com.elitescloud.boot.support.app.CloudtAppHolder;
import com.elitescloud.boot.util.JSONUtil;
import org.slf4j.Logger;

public class LogMessageQueueStorage
implements MessageQueueStorage {
    private static final Logger logger = CloudtBootLoggerFactory.MQ.getLogger(LogMessageQueueStorage.class);

    @Override
    public void saveMessage(StoreMessageDTO messageDTO) {
        logger.info("send message\uff1a{}, {}", (Object)messageDTO.getMessageId(), (Object)JSONUtil.toJsonString((Object)messageDTO));
    }

    @Override
    public void updateSendResult(String messageId, boolean success, String failReason) {
        logger.info("send message result:{}, {}, {}", new Object[]{messageId, success, failReason});
    }

    @Override
    public void updateConsumeResult(String messageId, boolean success, String failReason, long cost) {
        logger.info("consume message:{}, {}, {}, {}, {}, {}", new Object[]{CloudtAppHolder.getAppCode(), CloudtAppHolder.getServerIp(), messageId, success, failReason, cost});
    }
}

