/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.mybatis.config.tenant;

import com.baomidou.mybatisplus.extension.plugins.handler.TenantLineHandler;
import com.baomidou.mybatisplus.extension.plugins.inner.TenantLineInnerInterceptor;
import com.elitescloud.boot.condition.ConditionalOnTenant;
import com.elitescloud.boot.mybatis.config.CloudtMybatisAutoConfiguration;
import com.elitescloud.boot.mybatis.config.tenant.CloudtTenantLineHandler;
import com.elitescloud.boot.provider.TenantClientProvider;
import com.elitescloud.boot.tenant.client.TenantClientProperties;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.core.annotation.Order;

@AutoConfiguration(before={CloudtMybatisAutoConfiguration.class})
@ConditionalOnTenant
@ConditionalOnProperty(prefix="elitesland.mybatis", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class CloudtMybatisTenantAutoConfiguration {
    private final TenantClientProperties tenantClientProperties;
    private final TenantClientProvider tenantClientProvider;

    public CloudtMybatisTenantAutoConfiguration(TenantClientProperties tenantClientProperties, TenantClientProvider tenantClientProvider) {
        this.tenantClientProperties = tenantClientProperties;
        this.tenantClientProvider = tenantClientProvider;
    }

    @Bean
    public TenantLineHandler tenantLineHandler() {
        return new CloudtTenantLineHandler(this.tenantClientProperties, this.tenantClientProvider);
    }

    @Bean
    @Order(value=11)
    public TenantLineInnerInterceptor tenantLineInnerInterceptor(TenantLineHandler tenantLineHandler) {
        TenantLineInnerInterceptor interceptor = new TenantLineInnerInterceptor();
        interceptor.setTenantLineHandler(tenantLineHandler);
        return interceptor;
    }
}

