/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.mybatis.util;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.conditions.interfaces.Join;
import com.baomidou.mybatisplus.core.metadata.TableFieldInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.elitescloud.boot.datasecurity.common.DataSecurityUtil;
import com.elitescloud.boot.datasecurity.dpr.content.DprRuleConditionEnum;
import com.elitescloud.boot.datasecurity.dpr.content.DprRuleRelationEnum;
import com.elitescloud.cloudt.system.dto.BaseDataSecurityRuleDTO;
import com.elitescloud.cloudt.system.dto.SysDprRoleApiDataRuleListQueryDTO;
import com.elitescloud.cloudt.system.dto.SysDprRoleApiRowColumnRuleDTO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.springframework.util.Assert;

public class MyBatisDataSecurityUtil {
    public static <T> void applyDataPermission(Join<?> wrapper, Class<T> entityClass) {
        SysDprRoleApiRowColumnRuleDTO dataPermission = DataSecurityUtil.getDataPermission();
        if (dataPermission == null || CollUtil.isEmpty((Collection)dataPermission.getSysDprRoleApiDataRuleListQueryDTO())) {
            return;
        }
        TableInfo tableInfo = TableInfoHelper.getTableInfo(entityClass);
        Assert.notNull((Object)tableInfo, () -> "\u5b9e\u4f53[" + entityClass.getName() + "]\u672a\u627e\u5230\u5bf9\u5e94\u7684\u8868\u4fe1\u606f");
        Map<String, List<SysDprRoleApiDataRuleListQueryDTO>> rolePermissionMap = dataPermission.getSysDprRoleApiDataRuleListQueryDTO().stream().collect(Collectors.groupingBy(BaseDataSecurityRuleDTO::getRoleCode));
        StringJoiner joiner = new StringJoiner(" or ", "(", ")");
        boolean sqlEmpty = true;
        AtomicInteger paramIndex = new AtomicInteger(0);
        ArrayList<Object> params = new ArrayList<Object>(64);
        for (Map.Entry<String, List<SysDprRoleApiDataRuleListQueryDTO>> rolePermissionEntry : rolePermissionMap.entrySet()) {
            DprRuleRelationEnum relation = DataSecurityUtil.getRelation(rolePermissionEntry.getValue());
            String sql = MyBatisDataSecurityUtil.buildPredicate(tableInfo, relation, rolePermissionEntry.getValue(), params, paramIndex);
            if (sql == null) continue;
            joiner.add(sql);
            sqlEmpty = false;
        }
        if (sqlEmpty) {
            return;
        }
        String sql = joiner.toString();
        wrapper.apply(sql, params.toArray());
    }

    private static String buildPredicate(TableInfo tableInfo, DprRuleRelationEnum relation, List<SysDprRoleApiDataRuleListQueryDTO> ruleList, List<Object> params, AtomicInteger paramIndex) {
        if (CollUtil.isEmpty(ruleList)) {
            return null;
        }
        StringJoiner joiner = new StringJoiner(relation == DprRuleRelationEnum.DPR_RULE_RELATION_OR ? " or " : " and ", "(", ")");
        String exp = null;
        boolean sqlEmpty = true;
        for (SysDprRoleApiDataRuleListQueryDTO rule : ruleList) {
            if (Boolean.TRUE.equals(rule.getRuleGroup())) {
                exp = MyBatisDataSecurityUtil.buildPredicate(tableInfo, DprRuleRelationEnum.valueOf((String)rule.getDprRuleRelation()), rule.getGroupRules(), params, paramIndex);
                if (exp == null) continue;
                joiner.add(exp);
                sqlEmpty = false;
                continue;
            }
            TableFieldInfo fieldInfo = tableInfo.getFieldList().stream().filter(t -> t.getProperty().equals(rule.getDprRuleField())).findFirst().orElse(null);
            if (fieldInfo == null) continue;
            String[] values = rule.getDprRuleValue().split(",");
            DprRuleConditionEnum condition = DprRuleConditionEnum.valueOf((String)rule.getDprRuleCondition());
            Object sql = fieldInfo.getColumn();
            switch (condition) {
                case Equal: 
                case InList: {
                    sql = (String)sql + " in " + MyBatisDataSecurityUtil.generatePlaceholder(paramIndex.getAndAdd(values.length), values.length);
                    break;
                }
                case NotEqual: 
                case NotIn: {
                    sql = (String)sql + " not in " + MyBatisDataSecurityUtil.generatePlaceholder(paramIndex.getAndAdd(values.length), values.length);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u6761\u4ef6\uff1a" + condition);
                }
            }
            joiner.add((CharSequence)sql);
            sqlEmpty = false;
            Collections.addAll(params, values);
        }
        if (sqlEmpty) {
            return null;
        }
        return joiner.toString();
    }

    private static String generatePlaceholder(int startIndex, int size) {
        StringJoiner joiner = new StringJoiner(",", "(", ")");
        for (int i = 0; i < size; ++i) {
            joiner.add("{" + startIndex++ + "}");
        }
        return joiner.toString();
    }
}

