/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.mybatis.config.support.interceptor;

import com.baomidou.mybatisplus.core.toolkit.PluginUtils;
import com.elitescloud.boot.common.CloudtBootLoggerFactory;
import com.elitescloud.boot.data.util.JsqlParserUtil;
import com.elitescloud.boot.mybatis.common.AbstractCloudtInnerInterceptor;
import com.elitescloud.boot.mybatis.config.support.interceptor.CloudtAuditInterceptor;
import java.sql.Connection;
import java.sql.SQLException;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.delete.Delete;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.update.Update;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;

public class CloudtLogicDeleteInterceptor
extends AbstractCloudtInnerInterceptor {
    private static final Logger logger = CloudtBootLoggerFactory.REPO_MYBATIS.getLogger(CloudtLogicDeleteInterceptor.class);
    private static final String DELETE_COLUMN_NAME = "delete_flag";

    @Override
    public void beforeQuery(Executor executor, MappedStatement ms, Object parameter, RowBounds rowBounds, ResultHandler resultHandler, BoundSql boundSql) throws SQLException {
        if (ms.getSqlCommandType() == SqlCommandType.SELECT) {
            this.dealForQuery((Select)this.parseSql(ms, boundSql.getSql()), boundSql);
            return;
        }
    }

    @Override
    public void beforePrepare(StatementHandler sh, Connection connection, Integer transactionTimeout) {
        super.beforePrepare(sh, connection, transactionTimeout);
        if (super.hasExecuted(sh, CloudtAuditInterceptor.class)) {
            return;
        }
        PluginUtils.MPStatementHandler mpSh = PluginUtils.mpStatementHandler((StatementHandler)sh);
        MappedStatement ms = mpSh.mappedStatement();
        if (ms.getSqlCommandType() == SqlCommandType.UPDATE) {
            PluginUtils.MPBoundSql mpBs = mpSh.mPBoundSql();
            this.dealForUpdate((Update)this.parseSql(ms, mpBs.sql()), mpBs);
            return;
        }
        if (ms.getSqlCommandType() == SqlCommandType.DELETE) {
            PluginUtils.MPBoundSql mpBs = mpSh.mPBoundSql();
            this.dealForDelete((Delete)this.parseSql(ms, mpSh.mPBoundSql().sql()), mpBs);
            return;
        }
    }

    private void dealForQuery(Select statement, BoundSql boundSql) {
        PlainSelect selectBody = (PlainSelect)statement.getSelectBody();
        Table table = (Table)selectBody.getFromItem();
        if (!super.existsColumn(table.getName(), DELETE_COLUMN_NAME)) {
            return;
        }
        boolean existsDeleted = this.existsDeletedCause((Statement)statement, table);
        if (existsDeleted) {
            return;
        }
        Expression expression = this.generateUnDeletedExpression(table);
        selectBody.setWhere((Expression)(selectBody.getWhere() == null ? expression : new AndExpression(selectBody.getWhere(), expression)));
        PluginUtils.MPBoundSql mpbs = PluginUtils.mpBoundSql((BoundSql)boundSql);
        mpbs.sql(selectBody.toString());
    }

    private void dealForUpdate(Update statement, PluginUtils.MPBoundSql mpbs) {
        Table table = statement.getTable();
        if (!super.existsColumn(table.getName(), DELETE_COLUMN_NAME)) {
            return;
        }
        boolean existsDeleted = this.existsDeletedCause((Statement)statement, table);
        if (existsDeleted) {
            return;
        }
        Expression expression = this.generateUnDeletedExpression(table);
        statement.setWhere((Expression)(statement.getWhere() == null ? expression : new AndExpression(statement.getWhere(), expression)));
        mpbs.sql(statement.toString());
    }

    private void dealForDelete(Delete statement, PluginUtils.MPBoundSql mpbs) {
        Table table = statement.getTable();
        if (!super.existsColumn(table.getName(), DELETE_COLUMN_NAME)) {
            return;
        }
        boolean existsDeleted = this.existsDeletedCause((Statement)statement, table);
        if (existsDeleted) {
            return;
        }
        Expression expression = this.generateUnDeletedExpression(table);
        statement.setWhere((Expression)(statement.getWhere() == null ? expression : new AndExpression(statement.getWhere(), expression)));
        mpbs.sql(statement.toString());
    }

    private Expression generateUnDeletedExpression(Table table) {
        return new EqualsTo((Expression)new Column(table, DELETE_COLUMN_NAME), (Expression)new LongValue(0L));
    }

    private boolean existsDeletedCause(Statement statement, Table table) {
        return JsqlParserUtil.existsColumnOfWhere((Statement)statement, column -> {
            if (column.getTable() != null && !super.isSameTable(table, column.getTable())) {
                return false;
            }
            String columnName = column.getName(false);
            return DELETE_COLUMN_NAME.equalsIgnoreCase(columnName);
        });
    }
}

