/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.mybatis.config;

import cn.hutool.core.text.CharSequenceUtil;
import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.autoconfigure.ConfigurationCustomizer;
import com.baomidou.mybatisplus.autoconfigure.MybatisPlusInnerInterceptorAutoConfiguration;
import com.baomidou.mybatisplus.core.handlers.PostInitTableInfoHandler;
import com.baomidou.mybatisplus.core.incrementer.IdentifierGenerator;
import com.baomidou.mybatisplus.extension.plugins.MybatisPlusInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.PaginationInnerInterceptor;
import com.elitescloud.boot.common.CloudtBootLoggerFactory;
import com.elitescloud.boot.data.util.DatabaseUtil;
import com.elitescloud.boot.datasecurity.common.DataSecurityUtil;
import com.elitescloud.boot.mybatis.config.CloudtMybatisProperties;
import com.elitescloud.boot.mybatis.config.support.CloudtMetaObjectHandler;
import com.elitescloud.boot.mybatis.config.support.CloudtPostInitTableInfoHandler;
import com.elitescloud.boot.mybatis.config.support.interceptor.CloudtAuditInterceptor;
import com.elitescloud.boot.mybatis.config.support.interceptor.CloudtDataPermissionInterceptor;
import com.elitescloud.boot.mybatis.config.support.interceptor.CloudtLogicDeleteInterceptor;
import com.elitescloud.boot.provider.IdFactory;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.ibatis.type.TypeHandler;
import org.slf4j.Logger;
import org.springframework.beans.BeansException;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Primary;
import org.springframework.core.annotation.Order;
import org.springframework.lang.NonNull;
import org.springframework.orm.jpa.vendor.Database;
import org.springframework.util.Assert;

@AutoConfiguration(before={MybatisPlusInnerInterceptorAutoConfiguration.class})
@EnableConfigurationProperties(value={CloudtMybatisProperties.class})
@ConditionalOnProperty(prefix="elitesland.mybatis", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class CloudtMybatisAutoConfiguration
implements ApplicationContextAware,
ApplicationRunner {
    private static final Logger logger = CloudtBootLoggerFactory.REPO_MYBATIS.getLogger(CloudtMybatisAutoConfiguration.class);
    private final CloudtMybatisProperties cloudtMybatisProperties;
    private ApplicationContext applicationContext;

    public CloudtMybatisAutoConfiguration(CloudtMybatisProperties cloudtMybatisProperties) {
        this.cloudtMybatisProperties = cloudtMybatisProperties;
    }

    @Bean
    public ConfigurationCustomizer cloudtConfigurationCustomizer() {
        return configuration -> {
            if (CharSequenceUtil.isNotBlank((CharSequence)this.cloudtMybatisProperties.getMapTypeHandler())) {
                Class<?> typeHandlerMap = null;
                try {
                    typeHandlerMap = Class.forName(this.cloudtMybatisProperties.getMapTypeHandler());
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("\u7c7b" + this.cloudtMybatisProperties.getMapTypeHandler() + "\u4e0d\u5b58\u5728", e);
                }
                Assert.isTrue((boolean)TypeHandler.class.isAssignableFrom(typeHandlerMap), (String)"\u8bf7\u914d\u7f6e\u6b63\u786e\u7684\u81ea\u5b9a\u4e49\u7c7b\u578b\u5904\u7406\u5668\u7c7b\uff01");
                try {
                    configuration.getTypeHandlerRegistry().register(Map.class, (TypeHandler)typeHandlerMap.getConstructor(new Class[0]).newInstance(new Object[0]));
                }
                catch (Exception e) {
                    throw new RuntimeException("\u521d\u59cb\u5316\u81ea\u5b9a\u4e49\u7c7b\u578b\u5904\u7406\u5668\u5f02\u5e38\uff1a" + this.cloudtMybatisProperties.getMapTypeHandler(), e);
                }
            }
        };
    }

    @Bean
    @Order(value=31)
    @ConditionalOnProperty(prefix="elitesland.mybatis", name={"enabled-data-security"}, havingValue="true", matchIfMissing=true)
    @ConditionalOnClass(value={DataSecurityUtil.class})
    public CloudtDataPermissionInterceptor customDataPermissionInterceptor() {
        return new CloudtDataPermissionInterceptor();
    }

    @Bean
    @Order(value=51)
    @ConditionalOnProperty(prefix="elitesland.mybatis", name={"enabled-pagination"}, havingValue="true", matchIfMissing=true)
    public PaginationInnerInterceptor paginationInnerInterceptor(DataSource dataSource) {
        Database database = DatabaseUtil.getDatabaseType((DataSource)dataSource);
        DbType dbType = null;
        switch (database) {
            case MYSQL: {
                dbType = DbType.MYSQL;
                break;
            }
            case POSTGRESQL: {
                dbType = DbType.POSTGRE_SQL;
                break;
            }
            case ORACLE: {
                dbType = DbType.ORACLE;
                break;
            }
            case SQL_SERVER: {
                dbType = DbType.SQL_SERVER;
                break;
            }
            case DB2: {
                dbType = DbType.DB2;
                break;
            }
            case H2: {
                dbType = DbType.H2;
                break;
            }
            default: {
                logger.warn("Unsupported database type: {}", (Object)database);
            }
        }
        return new PaginationInnerInterceptor(dbType);
    }

    @Bean
    public IdentifierGenerator identifierGenerator() {
        return entity -> IdFactory.generateLong();
    }

    @Bean
    public PostInitTableInfoHandler cloudtPostInitTableInfoHandler() {
        return new CloudtPostInitTableInfoHandler(this.cloudtMybatisProperties);
    }

    @Bean
    @ConditionalOnProperty(prefix="elitesland.mybatis", name={"enabled-auto-fill"}, havingValue="true", matchIfMissing=true)
    public CloudtMetaObjectHandler cloudtMetaObjectHandler() {
        return new CloudtMetaObjectHandler();
    }

    @Bean
    @Order(value=21)
    @ConditionalOnProperty(prefix="elitesland.mybatis", name={"enabled-auto-fill"}, havingValue="true", matchIfMissing=true)
    public CloudtAuditInterceptor cloudtAuditInterceptor() {
        return new CloudtAuditInterceptor();
    }

    @Bean
    @Order(value=41)
    @ConditionalOnProperty(prefix="elitesland.mybatis", name={"enabled-auto-logic-delete"}, havingValue="true", matchIfMissing=true)
    public CloudtLogicDeleteInterceptor cloudtLogicDeleteInterceptor() {
        return new CloudtLogicDeleteInterceptor();
    }

    @Bean
    @Primary
    public MybatisPlusInterceptor cloudtMybatisPlusInterceptor(List<InnerInterceptor> innerInterceptorList) {
        MybatisPlusInterceptor plusInterceptor = new MybatisPlusInterceptor();
        plusInterceptor.setInterceptors(innerInterceptorList);
        return plusInterceptor;
    }

    public void setApplicationContext(@NonNull ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void run(ApplicationArguments args) throws Exception {
        Map mybatisPlusInterceptor = this.applicationContext.getBeansOfType(MybatisPlusInterceptor.class);
        if (mybatisPlusInterceptor.size() > 1) {
            logger.warn("\u5b58\u5728\u591a\u4e2a{}\u5b9e\u4f8b\uff1a{}", (Object)MybatisPlusInterceptor.class.getSimpleName(), (Object)String.join((CharSequence)",", mybatisPlusInterceptor.keySet()));
        }
    }
}

