/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.mybatis.config.tenant;

import com.baomidou.mybatisplus.extension.plugins.handler.TenantLineHandler;
import com.elitescloud.boot.context.TenantSession;
import com.elitescloud.boot.provider.TenantClientProvider;
import com.elitescloud.boot.tenant.client.TenantClientProperties;
import com.elitescloud.cloudt.common.constant.TenantIsolateStrategy;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.LongValue;

public class CloudtTenantLineHandler
implements TenantLineHandler {
    private final TenantClientProperties props;
    private final TenantClientProvider tenantClientProvider;

    public CloudtTenantLineHandler(TenantClientProperties props, TenantClientProvider tenantClientProvider) {
        this.props = props;
        this.tenantClientProvider = tenantClientProvider;
    }

    public boolean ignoreTable(String tableName) {
        boolean enabled = this.tenantClientProvider.enabledTenant();
        if (!enabled) {
            return true;
        }
        boolean noTenant = TenantSession.getNoTenant();
        if (noTenant) {
            return true;
        }
        return TenantIsolateStrategy.FIELD != this.props.getIsolateStrategy();
    }

    public Expression getTenantId() {
        SysTenantDTO tenant = this.tenantClientProvider.getSessionTenant();
        return new LongValue(tenant == null ? -1L : tenant.getId());
    }
}

