/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.mybatis.common;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.MybatisConfiguration;
import com.baomidou.mybatisplus.core.metadata.TableFieldInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.baomidou.mybatisplus.extension.parser.JsqlParserGlobal;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import com.elitescloud.boot.SpringContextHolder;
import com.elitescloud.boot.common.CloudtBootLoggerFactory;
import com.elitescloud.boot.mybatis.config.CloudtMybatisProperties;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.session.SqlSessionFactory;
import org.slf4j.Logger;

public abstract class AbstractCloudtInnerInterceptor
implements InnerInterceptor {
    private static final Logger logger = CloudtBootLoggerFactory.REPO_MYBATIS.getLogger(AbstractCloudtInnerInterceptor.class);
    private static final String CLOUDT_INTERCEPTOR_EXECUTED = "__cloudt_interceptor_executed";
    private CloudtMybatisProperties props;

    public void beforePrepare(StatementHandler sh, Connection connection, Integer transactionTimeout) {
        BoundSql boundSql = sh.getBoundSql();
        if (boundSql.getParameterObject() == null) {
            MetaObject metaBoundSql = SystemMetaObject.forObject((Object)boundSql);
            metaBoundSql.setValue("parameterObject", new HashMap(64));
        }
        this.markExecuted(boundSql);
    }

    public boolean willDoQuery(Executor executor, MappedStatement ms, Object parameter, RowBounds rowBounds, ResultHandler resultHandler, BoundSql boundSql) throws SQLException {
        this.markExecuted(boundSql);
        return super.willDoQuery(executor, ms, parameter, rowBounds, resultHandler, boundSql);
    }

    public boolean willDoUpdate(Executor executor, MappedStatement ms, Object parameter) throws SQLException {
        return super.willDoUpdate(executor, ms, parameter);
    }

    public void beforeQuery(Executor executor, MappedStatement ms, Object parameter, RowBounds rowBounds, ResultHandler resultHandler, BoundSql boundSql) throws SQLException {
        this.markExecuted(boundSql);
        super.beforeQuery(executor, ms, parameter, rowBounds, resultHandler, boundSql);
    }

    public void beforeUpdate(Executor executor, MappedStatement ms, Object parameter) throws SQLException {
        super.beforeUpdate(executor, ms, parameter);
    }

    public void beforeGetBoundSql(StatementHandler sh) {
        this.markExecuted(sh.getBoundSql());
        super.beforeGetBoundSql(sh);
    }

    protected Statement parseSql(@NotNull MappedStatement ms, @NotNull String sql) {
        try {
            return JsqlParserGlobal.parse((String)sql);
        }
        catch (JSQLParserException e) {
            logger.error("\u89e3\u6790SQL\u5f02\u5e38\uff1a{}, {}", new Object[]{ms.getId(), sql, e});
            throw new RuntimeException("\u89e3\u6790SQL\u5f02\u5e38", e);
        }
    }

    protected boolean isSameTable(@NotNull Table one, @NotNull Table two) {
        if (one == null || two == null) {
            return true;
        }
        if (!one.getName().equalsIgnoreCase(two.getName())) {
            return false;
        }
        if (one.getAlias() != null && two.getAlias() != null) {
            return one.getAlias().equals(two.getAlias());
        }
        return true;
    }

    protected TableInfo getTableInfo(@NotBlank String tableName) {
        return TableInfoHelper.getTableInfo((String)tableName);
    }

    protected TableInfo getTableInfo(@NotNull Class<?> entityClass) {
        return TableInfoHelper.getTableInfo(entityClass);
    }

    protected boolean existsColumn(@NotBlank String tableName, @NotBlank String columnName) {
        TableInfo tableInfo = TableInfoHelper.getTableInfo((String)tableName);
        if (tableInfo == null) {
            return false;
        }
        if (CollUtil.isEmpty((Collection)tableInfo.getFieldList())) {
            return false;
        }
        for (TableFieldInfo fieldInfo : tableInfo.getFieldList()) {
            if (!fieldInfo.getColumn().equalsIgnoreCase(columnName)) continue;
            return true;
        }
        return false;
    }

    protected List<TableFieldInfo> getFieldInfos(@NotBlank String tableName) {
        TableInfo tableInfo = TableInfoHelper.getTableInfo((String)tableName);
        if (tableInfo == null) {
            return Collections.emptyList();
        }
        if (CollUtil.isEmpty((Collection)tableInfo.getFieldList())) {
            return Collections.emptyList();
        }
        return tableInfo.getFieldList();
    }

    private void markExecuted(BoundSql boundSql) {
        List executedInterceptor = (List)boundSql.getAdditionalParameters().computeIfAbsent(CLOUDT_INTERCEPTOR_EXECUTED, k -> new ArrayList());
        executedInterceptor.add(this.getClass().getName());
    }

    protected boolean hasExecuted(BoundSql boundSql, Class<? extends AbstractCloudtInnerInterceptor> clazz) {
        List executedInterceptor = (List)boundSql.getAdditionalParameters().computeIfAbsent(CLOUDT_INTERCEPTOR_EXECUTED, k -> new ArrayList());
        return clazz != null && executedInterceptor.contains(clazz.getName());
    }

    protected boolean hasExecuted(StatementHandler sh, Class<? extends AbstractCloudtInnerInterceptor> clazz) {
        return this.hasExecuted(sh.getBoundSql(), clazz);
    }

    protected CloudtMybatisProperties getProps() {
        if (this.props == null) {
            this.props = (CloudtMybatisProperties)SpringContextHolder.getBean(CloudtMybatisProperties.class);
        }
        return this.props;
    }

    protected MybatisConfiguration getMybatisConfiguration() {
        return (MybatisConfiguration)((SqlSessionFactory)SpringContextHolder.getBean(SqlSessionFactory.class)).getConfiguration();
    }
}

