/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.mybatis.util;

import cn.hutool.core.util.ArrayUtil;
import com.elitescloud.boot.common.CloudtBootLoggerFactory;
import com.elitescloud.boot.util.ClassUtil;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.validation.constraints.NotBlank;
import org.slf4j.Logger;

public class MyBatisUtil {
    private static final Logger logger = CloudtBootLoggerFactory.REPO_MYBATIS.getLogger(MyBatisUtil.class);
    private static final ConcurrentHashMap<String, List<Method>> methodsCache = new ConcurrentHashMap();

    public static List<Method> getMethodsByMapperMethodId(@NotBlank String mapperMethodId) {
        return methodsCache.computeIfAbsent(mapperMethodId, k -> {
            int lastDotIndex = mapperMethodId.lastIndexOf(46);
            if (lastDotIndex == -1) {
                return Collections.emptyList();
            }
            String className = mapperMethodId.substring(0, lastDotIndex);
            String methodName = mapperMethodId.substring(lastDotIndex + 1);
            Class<?> mapperClass = null;
            try {
                mapperClass = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                logger.error("\u83b7\u53d6mapper\u65b9\u6cd5\u5931\u8d25\uff0c\u672a\u627e\u5230\u7c7b\uff1a{}", k, (Object)e);
            }
            if (mapperClass == null) {
                return Collections.emptyList();
            }
            Object[] methods = ClassUtil.getDeclaredMethods(mapperClass);
            if (ArrayUtil.isEmpty((Object[])methods)) {
                return Collections.emptyList();
            }
            return Arrays.stream(methods).filter(t -> t.getName().equals(methodName)).collect(Collectors.toList());
        });
    }
}

