/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.openfeign.interceptor;

import com.elitescloud.boot.provider.TenantClientProvider;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import feign.RequestInterceptor;
import feign.RequestTemplate;

public class TenantContextInterceptor
implements RequestInterceptor {
    private final TenantClientProvider tenantClientProvider;

    public TenantContextInterceptor(TenantClientProvider tenantClientProvider) {
        this.tenantClientProvider = tenantClientProvider;
    }

    public void apply(RequestTemplate template) {
        if (!this.tenantClientProvider.enabledTenant()) {
            template.removeHeader("X-Tenant-Id");
            return;
        }
        SysTenantDTO tenant = this.tenantClientProvider.getSessionTenant();
        if (tenant == null) {
            template.removeHeader("X-Tenant-Id");
            return;
        }
        template.header("X-Tenant-Id", new String[]{tenant.getId().toString()});
    }
}

