package com.elitescloud.boot.openfeign.config;

import org.springframework.cloud.client.DefaultServiceInstance;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.Request;
import org.springframework.cloud.client.loadbalancer.reactive.ReactiveLoadBalancer;
import org.springframework.cloud.loadbalancer.blocking.client.BlockingLoadBalancerClient;

/**
 * 自定义负载均衡客户端.
 * <p>
 * 判断如果调用的服务和当前服务名一样，则直接调用自己
 *
 * @author Kaiser（wang shao）
 * @date 2022/9/21
 */
public class CloudtBlockingLoadBalancerClient extends BlockingLoadBalancerClient {

    private final String applicationName;
    private final Integer port;
    private final ServiceInstance serviceInstance;

    @Override
    public ServiceInstance choose(String serviceId) {
        var instance = getServiceInstance(serviceId);
        if (instance != null) {
            return instance;
        }
        return super.choose(serviceId);
    }

    @Override
    public <T> ServiceInstance choose(String serviceId, Request<T> request) {
        var instance = getServiceInstance(serviceId);
        if (instance != null) {
            return instance;
        }
        return super.choose(serviceId, request);
    }

    public CloudtBlockingLoadBalancerClient(String applicationName, Integer port, ReactiveLoadBalancer.Factory<ServiceInstance> loadBalancerClientFactory) {
        super(loadBalancerClientFactory);
        this.applicationName = applicationName;
        this.port = port;
        this.serviceInstance = buildLocalInstance();
    }

    private ServiceInstance getServiceInstance(String serviceId) {
        if (applicationName != null && applicationName.equals(serviceId)) {
            // 当前应用
            return serviceInstance;
        }

        return null;
    }

    private ServiceInstance buildLocalInstance() {
        return new DefaultServiceInstance(applicationName, applicationName, "127.0.0.1", port, false);
    }
}
