package com.elitescloud.boot.openfeign.config;

import com.elitescloud.boot.constant.AuthenticationContextConstant;
import com.elitescloud.boot.provider.TenantClientProvider;
import feign.RequestInterceptor;
import feign.RequestTemplate;

/**
 * 租户上下文传递.
 *
 * @author Kaiser（wang shao）
 * @date 2022/10/16
 */
class TenantContextInterceptor implements RequestInterceptor {

    private final TenantClientProvider tenantClientProvider;

    public TenantContextInterceptor(TenantClientProvider tenantClientProvider) {
        this.tenantClientProvider = tenantClientProvider;
    }

    @Override
    public void apply(RequestTemplate template) {
        if (!tenantClientProvider.enabledTenant()) {
            // 未启用租户
            template.removeHeader(AuthenticationContextConstant.CURRENT_TENANT_ID);
            return;
        }

        var tenant = tenantClientProvider.getSessionTenant();
        if (tenant == null) {
            template.removeHeader(AuthenticationContextConstant.CURRENT_TENANT_ID);
            return;
        }
        template.header(AuthenticationContextConstant.CURRENT_TENANT_ID, tenant.getId().toString());
    }
}
