/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.openfeign.config;

import org.springframework.cloud.client.DefaultServiceInstance;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.Request;
import org.springframework.cloud.client.loadbalancer.reactive.ReactiveLoadBalancer;
import org.springframework.cloud.loadbalancer.blocking.client.BlockingLoadBalancerClient;

class CloudtBlockingLoadBalancerClient
extends BlockingLoadBalancerClient {
    private final String applicationName;
    private final Integer port;
    private final ServiceInstance serviceInstance;

    public ServiceInstance choose(String serviceId) {
        ServiceInstance instance = this.getServiceInstance(serviceId);
        if (instance != null) {
            return instance;
        }
        return super.choose(serviceId);
    }

    public <T> ServiceInstance choose(String serviceId, Request<T> request) {
        ServiceInstance instance = this.getServiceInstance(serviceId);
        if (instance != null) {
            return instance;
        }
        return super.choose(serviceId, request);
    }

    public CloudtBlockingLoadBalancerClient(String applicationName, Integer port, ReactiveLoadBalancer.Factory<ServiceInstance> loadBalancerClientFactory) {
        super(loadBalancerClientFactory);
        this.applicationName = applicationName;
        this.port = port;
        this.serviceInstance = this.buildLocalInstance();
    }

    private ServiceInstance getServiceInstance(String serviceId) {
        if (this.applicationName != null && this.applicationName.equals(serviceId)) {
            return this.serviceInstance;
        }
        return null;
    }

    private ServiceInstance buildLocalInstance() {
        return new DefaultServiceInstance(this.applicationName, this.applicationName, "127.0.0.1", this.port.intValue(), false);
    }
}

