package com.elitescloud.boot.openfeign.config;

import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.constant.OpenFeignConstant;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import lombok.extern.log4j.Log4j2;
import org.springframework.http.HttpHeaders;
import org.springframework.util.StringUtils;

/**
 * 用户上下文信息的传递.
 *
 * @author Kaiser（wang shao）
 * @date 2022/7/27
 */
@Log4j2
class FeignAuthenticationContextInterceptor implements RequestInterceptor {

    @Override
    public void apply(RequestTemplate template) {
        GeneralUserDetails user = SecurityContextUtil.currentUser();
        if (user == null) {
            log.debug("调用OpenFeign时传递用户信息失败，未获取到当前用户信息");
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("OpenFeign调用，传递Token：{}", SecurityContextUtil::currentToken);
        }

        if (user.getUser() != null) {
            // 只有当前信息不为空才需要设置
            template.header(OpenFeignConstant.CURRENT_USER_ID, user.getUser().getId().toString());
            template.header(OpenFeignConstant.CURRENT_USER_NAME, user.getUser().getUsername());

            String token = SecurityContextUtil.currentToken();
            if (StringUtils.hasText(token)) {
                template.header(OpenFeignConstant.CURRENT_AUTH_TOKEN, token);

                template.header(HttpHeaders.AUTHORIZATION, OpenFeignConstant.TOKEN_TYPE + " " + token);
            }
        } else {
            template.removeHeader(OpenFeignConstant.CURRENT_USER_ID);
            template.removeHeader(OpenFeignConstant.CURRENT_USER_NAME);
            template.removeHeader(OpenFeignConstant.CURRENT_AUTH_TOKEN);
            template.removeHeader(HttpHeaders.AUTHORIZATION);
        }
    }
}
