/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.openfeign.common;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.cloud.openfeign.FeignClientBuilder;
import org.springframework.context.ApplicationContext;
import org.springframework.lang.NonNull;
import org.springframework.util.StringUtils;

public class DynamicClientHelper {
    private final FeignClientBuilder feignClientBuilder;
    private static final Map<String, Object> CLIENT_CACHE = new ConcurrentHashMap<String, Object>();

    public DynamicClientHelper(ApplicationContext applicationContext) {
        this.feignClientBuilder = new FeignClientBuilder(applicationContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getClient(@NonNull String serviceName, @NonNull Class<T> clazz, String path) {
        String key = serviceName + ":" + clazz.getName();
        Object client = CLIENT_CACHE.get(key);
        if (client != null) {
            return (T)client;
        }
        Map<String, Object> map = CLIENT_CACHE;
        synchronized (map) {
            client = CLIENT_CACHE.get(key);
            if (client != null) {
                return (T)client;
            }
            FeignClientBuilder.Builder clientBuilder = this.feignClientBuilder.forType(clazz, serviceName);
            if (StringUtils.hasText((String)path)) {
                clientBuilder.path(path);
            }
            client = clientBuilder.build();
            CLIENT_CACHE.put(key, client);
        }
        return (T)client;
    }
}

