package com.elitescloud.boot.openfeign.config;

import com.elitescloud.boot.constant.WebConstant;
import com.elitescloud.boot.openfeign.common.CloudtOpenFeignConstant;
import com.elitescloud.cloudt.context.util.HttpServletUtil;
import feign.RequestInterceptor;
import feign.RequestTemplate;

import java.util.ArrayList;
import java.util.List;

/**
 * 云梯请求头.
 *
 * @author Kaiser（wang shao）
 * @date 2023/9/15
 */
class CloudtHeaderInterceptor implements RequestInterceptor {

    @Override
    public void apply(RequestTemplate template) {
        var request = HttpServletUtil.currentRequest();
        if (request == null) {
            return;
        }

        var headers = request.getHeaderNames().asIterator();
        while (headers.hasNext()) {
            var name = headers.next();
            if (name.equalsIgnoreCase(WebConstant.HEADER_REPEAT)) {
                continue;
            }
            if (name.equalsIgnoreCase(WebConstant.HEADER_MENU_CODE)) {
                continue;
            }
            if (!name.startsWith(CloudtOpenFeignConstant.HEADER_CLOUDT_PREFIX)) {
                continue;
            }

            List<String> values = new ArrayList<>(8);
            request.getHeaders(name).asIterator().forEachRemaining(values::add);
            template.header(name, values);
        }
    }
}
