package com.elitescloud.boot.openfeign.config;

import feign.Feign;
import feign.Target;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.cloud.openfeign.FeignClientFactoryBean;
import org.springframework.cloud.openfeign.FeignContext;
import org.springframework.cloud.openfeign.Targeter;
import org.springframework.core.type.AnnotationMetadata;

import java.util.Map;

/**
 * Target代理.
 * <p>
 * 在OpenFeign的{@link org.springframework.cloud.openfeign.FeignClientsRegistrar#registerFeignClient(BeanDefinitionRegistry, AnnotationMetadata, Map)}处通过FeignClientFactoryBean
 * 来给所有FeignClient生成bean，其类型为Targeter。通过代理替换其targeter对象，判断如果是本地已有实现bean，走直接使用本地的spring bean，而不是使用openfeign的。
 *
 * @author Kaiser（wang shao）
 * @date 2024/6/5
 */
class CloudtTargeter implements Targeter {

    private final TargeterProxy proxy;

    public CloudtTargeter(TargeterProxy proxy) {
        this.proxy = proxy;
    }

    @Override
    public <T> T target(FeignClientFactoryBean factory, Feign.Builder feign, FeignContext context, Target.HardCodedTarget<T> target) {
        return proxy.target(factory, feign, context, target);
    }
}
