package com.elitescloud.boot.openfeign.config;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.base.AbstractLogTraceHandler;
import com.elitescloud.boot.constant.CommonConstant;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import org.slf4j.MDC;

/**
 * feign链路日志跟踪处理.
 *
 * @author Kaiser（wang shao）
 * @date 2021/12/23
 */
class FeignTraceLogInterceptor extends AbstractLogTraceHandler implements RequestInterceptor {

    public FeignTraceLogInterceptor(String traceIdPrefix) {
        super(traceIdPrefix);
    }

    @Override
    public void apply(RequestTemplate template) {
        String traceId = MDC.get(CommonConstant.LOG_TRACE_ID);
        if (CharSequenceUtil.isBlank(traceId)) {
            traceId = putTraceId();
        }
        template.header(CommonConstant.LOG_TRACE_ID, traceId);
    }
}
