package com.elitescloud.boot.openfeign.config.web;

import com.elitescloud.boot.web.common.RequestMappingHandlerMappingCustomizer;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.lang.NonNull;


/**
 * RequestMappingHandlerMapping忽略FeignClient.
 *
 * @author Kaiser（wang shao）
 * @date 2024/4/24
 */
public class FeignClientRequestMappingHandlerMappingCustomizer implements RequestMappingHandlerMappingCustomizer {

    @Override
    public boolean isHandler(@NonNull Class<?> beanType) {
        return !beanType.isAnnotationPresent(FeignClient.class);
    }
}
