/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.openfeign.config;

import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.client.DefaultServiceInstance;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.DefaultRequestContext;
import org.springframework.cloud.client.loadbalancer.Request;
import org.springframework.cloud.client.loadbalancer.RequestData;
import org.springframework.cloud.client.loadbalancer.reactive.ReactiveLoadBalancer;
import org.springframework.cloud.loadbalancer.blocking.client.BlockingLoadBalancerClient;

class CloudtBlockingLoadBalancerClient
extends BlockingLoadBalancerClient {
    private static final Logger logger = LoggerFactory.getLogger(CloudtBlockingLoadBalancerClient.class);
    private final String applicationName;
    private final Integer port;
    private final ServiceInstance serviceInstance;

    public <T> ServiceInstance choose(String serviceId, Request<T> request) {
        ServiceInstance instance = this.getServiceInstance(serviceId);
        if (instance != null) {
            logger.info("LoadBalancer ServiceInstance: {}, {}, {}", new Object[]{serviceId, instance.getHost(), instance.getPort()});
            return instance;
        }
        instance = super.choose(serviceId, request);
        if (instance == null) {
            instance = this.attemptBuildServiceInstanceForIpAndPort(request.getContext());
        }
        logger.info("LoadBalancer ServiceInstance: {}, {}, {}", new Object[]{serviceId, instance == null ? null : instance.getHost(), instance == null ? null : Integer.valueOf(instance.getPort())});
        return instance;
    }

    public CloudtBlockingLoadBalancerClient(String applicationName, Integer port, ReactiveLoadBalancer.Factory<ServiceInstance> loadBalancerClientFactory) {
        super(loadBalancerClientFactory);
        this.applicationName = applicationName;
        this.port = port;
        this.serviceInstance = this.buildLocalInstance();
    }

    private <T> ServiceInstance attemptBuildServiceInstanceForIpAndPort(T context) {
        if (!(context instanceof DefaultRequestContext)) {
            return null;
        }
        DefaultRequestContext requestContext = (DefaultRequestContext)context;
        Object clientRequest = requestContext.getClientRequest();
        if (!(clientRequest instanceof RequestData)) {
            return null;
        }
        RequestData requestData = (RequestData)clientRequest;
        URI url = requestData.getUrl();
        if (url == null) {
            return null;
        }
        return new DefaultServiceInstance(url.getAuthority(), url.getAuthority(), url.getHost(), url.getPort(), "https".equalsIgnoreCase(url.getScheme()));
    }

    private ServiceInstance getServiceInstance(String serviceId) {
        if (this.applicationName != null && this.applicationName.equals(serviceId)) {
            return this.serviceInstance;
        }
        return null;
    }

    private ServiceInstance buildLocalInstance() {
        return new DefaultServiceInstance(this.applicationName, this.applicationName, "127.0.0.1", this.port.intValue(), false);
    }
}

