/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.openfeign.config;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.boot.common.CloudtBootLoggerFactory;
import com.elitescloud.boot.openfeign.config.CloudtOpenFeignProperties;
import com.elitescloud.boot.util.ValidateUtil;
import java.net.URI;
import org.slf4j.Logger;
import org.springframework.cloud.client.DefaultServiceInstance;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.DefaultRequestContext;
import org.springframework.cloud.client.loadbalancer.Request;
import org.springframework.cloud.client.loadbalancer.RequestData;
import org.springframework.cloud.client.loadbalancer.reactive.ReactiveLoadBalancer;
import org.springframework.cloud.loadbalancer.blocking.client.BlockingLoadBalancerClient;
import org.springframework.util.StringUtils;

class CloudtBlockingLoadBalancerClient
extends BlockingLoadBalancerClient {
    private static final Logger logger = CloudtBootLoggerFactory.RPC_OPENFEIGN.getLogger(CloudtBlockingLoadBalancerClient.class);
    private final String applicationName;
    private final Integer port;
    private final ServiceInstance serviceInstance;
    private final CloudtOpenFeignProperties properties;

    CloudtBlockingLoadBalancerClient(String applicationName, Integer port, ReactiveLoadBalancer.Factory<ServiceInstance> loadBalancerClientFactory, CloudtOpenFeignProperties properties) {
        super(loadBalancerClientFactory);
        this.applicationName = applicationName;
        this.port = port;
        this.properties = properties;
        this.serviceInstance = this.buildLocalInstance();
    }

    public <T> ServiceInstance choose(String serviceId, Request<T> request) {
        ServiceInstance instance = this.attemptToMatchLocalService(serviceId = this.routeService(serviceId));
        if (instance != null) {
            logger.info("LoadBalancer ServiceInstance: {}, {}, {}", new Object[]{serviceId, instance.getHost(), instance.getPort()});
            return instance;
        }
        instance = super.choose(serviceId, request);
        if (instance == null) {
            instance = this.attemptBuildServiceInstanceForIpAndPort(serviceId, request.getContext());
        }
        logger.info("LoadBalancer ServiceInstance: {}, {}, {}", new Object[]{serviceId, instance == null ? null : instance.getHost(), instance == null ? null : Integer.valueOf(instance.getPort())});
        return instance;
    }

    private <T> ServiceInstance attemptBuildServiceInstanceForIpAndPort(String serviceId, T context) {
        ServiceInstance instance = this.attemptToMatchIpAndPort(serviceId);
        if (instance != null) {
            return instance;
        }
        if (!(context instanceof DefaultRequestContext)) {
            return null;
        }
        DefaultRequestContext requestContext = (DefaultRequestContext)context;
        Object clientRequest = requestContext.getClientRequest();
        if (!(clientRequest instanceof RequestData)) {
            return null;
        }
        RequestData requestData = (RequestData)clientRequest;
        URI url = requestData.getUrl();
        if (url == null) {
            return null;
        }
        return new DefaultServiceInstance(url.getAuthority(), url.getAuthority(), url.getHost(), url.getPort(), "https".equalsIgnoreCase(url.getScheme()));
    }

    private ServiceInstance attemptToMatchIpAndPort(String serviceId) {
        if (!ValidateUtil.isIpOrIpAndPort((String)serviceId)) {
            return null;
        }
        String[] ipAndPorts = serviceId.split(":");
        if (ipAndPorts.length == 1) {
            return new DefaultServiceInstance(serviceId, serviceId, serviceId, 8080, false);
        }
        return new DefaultServiceInstance(serviceId, serviceId, ipAndPorts[0], Integer.parseInt(ipAndPorts[1]), false);
    }

    private String routeService(String serviceId) {
        if (CollUtil.isEmpty(this.properties.getServiceRouter()) || !this.properties.getServiceRouter().containsKey(serviceId)) {
            return serviceId;
        }
        String routerServiceId = this.properties.getServiceRouter().get(serviceId);
        routerServiceId = StringUtils.hasText((String)routerServiceId) ? routerServiceId : this.applicationName;
        logger.info("service router: {} -> {}", (Object)serviceId, (Object)routerServiceId);
        return routerServiceId;
    }

    private ServiceInstance attemptToMatchLocalService(String serviceId) {
        if (this.applicationName != null && this.applicationName.equals(serviceId)) {
            return this.serviceInstance;
        }
        return null;
    }

    private ServiceInstance buildLocalInstance() {
        return new DefaultServiceInstance(this.applicationName, this.applicationName, "127.0.0.1", this.port.intValue(), false);
    }
}

