/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.openfeign.config;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.boot.SpringContextHolder;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.openfeign.config.CloudtOpenFeignProperties;
import com.elitescloud.boot.util.ProxyUtil;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.param.QueryParam;
import feign.Feign;
import feign.Target;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.openfeign.FeignClientFactoryBean;
import org.springframework.cloud.openfeign.FeignContext;
import org.springframework.cloud.openfeign.Targeter;

class TargeterProxy
implements Targeter {
    private final Targeter proxy;
    private final Set<String> localServiceIds;
    private final CloudtOpenFeignProperties properties;

    public TargeterProxy(Targeter proxy, Set<String> localServiceIds, CloudtOpenFeignProperties properties) {
        this.proxy = proxy;
        this.localServiceIds = localServiceIds;
        this.properties = properties;
    }

    public <T> T target(FeignClientFactoryBean factory, Feign.Builder feign, FeignContext context, Target.HardCodedTarget<T> target) {
        Object instance = this.proxy.target(factory, feign, context, target);
        if (this.needProxy(target.name())) {
            return (T)Proxy.newProxyInstance(target.getClass().getClassLoader(), new Class[]{target.type()}, (InvocationHandler)new LocalBeanTarget(target.type(), instance, this.properties));
        }
        return (T)instance;
    }

    private boolean needProxy(String targetName) {
        if (CollUtil.isEmpty(this.localServiceIds)) {
            return false;
        }
        boolean proxyAll = this.localServiceIds.stream().anyMatch("*"::equals);
        if (proxyAll) {
            return true;
        }
        if (CharSequenceUtil.isBlank((CharSequence)targetName)) {
            return false;
        }
        return this.localServiceIds.contains(targetName);
    }

    static class LocalBeanTarget
    implements InvocationHandler {
        private static final Logger log = LoggerFactory.getLogger(LocalBeanTarget.class);
        private final Class<?> feignClientInterface;
        private final Object feignProxy;
        private final CloudtOpenFeignProperties properties;
        private Object bean = null;
        private boolean initialized = false;

        public LocalBeanTarget(Class<?> clazz, Object feignInstance, CloudtOpenFeignProperties properties) {
            this.feignClientInterface = clazz;
            this.feignProxy = feignInstance;
            this.properties = properties;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            void var5_9;
            String string = method.getName();
            int n = -1;
            switch (string.hashCode()) {
                case -1295482945: {
                    if (!string.equals("equals")) break;
                    boolean bl = false;
                    break;
                }
                case 147696667: {
                    if (!string.equals("hashCode")) break;
                    boolean bl = true;
                    break;
                }
                case -1776922004: {
                    if (!string.equals("toString")) break;
                    int n2 = 2;
                }
            }
            switch (var5_9) {
                case 0: {
                    try {
                        InvocationHandler otherHandler = args.length > 0 && args[0] != null ? Proxy.getInvocationHandler(args[0]) : null;
                        return this.equals(otherHandler);
                    }
                    catch (IllegalArgumentException e) {
                        return false;
                    }
                }
                case 1: {
                    return this.hashCode();
                }
                case 2: {
                    return "cloudtFeignClient_local_" + this.feignClientInterface.getName();
                }
            }
            if (Boolean.FALSE.equals(this.properties.getDirectLocal())) {
                return method.invoke(this.feignProxy, args);
            }
            if (this.initialized) {
                return this.invokeLocal(this.bean, method, args);
            }
            if (!SpringContextHolder.initialized()) {
                return method.invoke(this.feignProxy, args);
            }
            for (Map.Entry entry : SpringContextHolder.getBeans(this.feignClientInterface).entrySet()) {
                if (ProxyUtil.getTargetBeanForSpring(entry.getValue()) instanceof Proxy) continue;
                this.bean = entry.getValue();
                this.initialized = true;
                log.info("{} used local bean\uff1a{}", (Object)this.feignClientInterface.getName(), entry.getKey());
                break;
            }
            if (!this.initialized) {
                this.bean = this.feignProxy;
                this.initialized = true;
            }
            return this.invokeLocal(this.bean, method, args);
        }

        private Object invokeLocal(Object bean, Method method, Object[] args) throws InvocationTargetException, IllegalAccessException {
            args = this.transformArgsForInvokeLocal(args);
            if (method.getReturnType().isAssignableFrom(ApiResult.class)) {
                try {
                    return method.invoke(bean, args);
                }
                catch (Throwable e) {
                    Throwable exp = this.getTargetException(e);
                    log.error("\u8c03\u7528RPC\u63a5\u53e3\u5f02\u5e38\uff1a", exp);
                    if (exp instanceof BusinessException) {
                        BusinessException businessException = (BusinessException)exp;
                        Integer errorCode = (Integer)ObjectUtil.defaultIfNull((Object)businessException.getCode(), (Object)ApiCode.FAIL.getCode());
                        return ApiResult.fail((int)errorCode, (String)exp.getMessage());
                    }
                    return ApiResult.fail((String)exp.getMessage());
                }
            }
            return method.invoke(bean, args);
        }

        private Throwable getTargetException(Throwable e) {
            Throwable cause;
            for (cause = e.getCause(); cause != null && cause instanceof ReflectiveOperationException; cause = cause.getCause()) {
            }
            return cause;
        }

        private Object[] transformArgsForInvokeLocal(Object[] args) {
            if (ArrayUtil.isEmpty((Object[])args)) {
                return args;
            }
            for (Object arg : args) {
                if (!(arg instanceof QueryParam)) continue;
                QueryParam queryParam = (QueryParam)arg;
                queryParam.setCurrent(queryParam.getCurrent());
            }
            return args;
        }
    }
}

