/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.openfeign.config;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.common.CloudtBootLoggerFactory;
import com.elitescloud.boot.openfeign.config.CloudtOpenFeignProperties;
import com.elitescloud.boot.util.ValidateUtil;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.net.URI;
import java.time.Duration;
import org.slf4j.Logger;
import org.springframework.cloud.client.DefaultServiceInstance;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.DefaultRequestContext;
import org.springframework.cloud.client.loadbalancer.Request;
import org.springframework.cloud.client.loadbalancer.RequestData;
import org.springframework.cloud.client.loadbalancer.reactive.ReactiveLoadBalancer;
import org.springframework.cloud.loadbalancer.blocking.client.BlockingLoadBalancerClient;
import org.springframework.http.server.PathContainer;
import org.springframework.web.util.pattern.PathPattern;
import org.springframework.web.util.pattern.PathPatternParser;

class CloudtBlockingLoadBalancerClient
extends BlockingLoadBalancerClient {
    private static final Logger logger = CloudtBootLoggerFactory.RPC_OPENFEIGN.getLogger(CloudtBlockingLoadBalancerClient.class);
    private final String applicationName;
    private final Integer port;
    private final ServiceInstance serviceInstance;
    private final CloudtOpenFeignProperties properties;
    private final Cache<String, PathPattern> serviceMethodPatterns;

    CloudtBlockingLoadBalancerClient(String applicationName, Integer port, ReactiveLoadBalancer.Factory<ServiceInstance> loadBalancerClientFactory, CloudtOpenFeignProperties properties) {
        super(loadBalancerClientFactory);
        this.applicationName = applicationName;
        this.port = port;
        this.properties = properties;
        this.serviceMethodPatterns = Caffeine.newBuilder().maximumSize(200L).expireAfterWrite(Duration.ofDays(7L)).build();
        this.serviceInstance = this.buildLocalInstance();
    }

    public <T> ServiceInstance choose(String serviceId, Request<T> request) {
        ServiceInstance instance = this.attemptToMatchLocalService(serviceId = this.routeService(serviceId, request));
        if (instance != null) {
            logger.info("LoadBalancer ServiceInstance: {}, {}, {}", new Object[]{serviceId, instance.getHost(), instance.getPort()});
            return instance;
        }
        instance = super.choose(serviceId, request);
        if (instance == null) {
            instance = this.attemptBuildServiceInstanceForIpAndPort(serviceId, request.getContext());
        }
        logger.info("LoadBalancer ServiceInstance: {}, {}, {}", new Object[]{serviceId, instance == null ? null : instance.getHost(), instance == null ? null : Integer.valueOf(instance.getPort())});
        return instance;
    }

    private <T> ServiceInstance attemptBuildServiceInstanceForIpAndPort(String serviceId, T context) {
        ServiceInstance instance = this.attemptToMatchIpAndPort(serviceId);
        if (instance != null) {
            return instance;
        }
        RequestData requestData = this.obtainRequestDataFromContext(context);
        if (requestData == null) {
            return null;
        }
        URI url = requestData.getUrl();
        if (url == null) {
            return null;
        }
        return new DefaultServiceInstance(url.getAuthority(), url.getAuthority(), url.getHost(), url.getPort(), "https".equalsIgnoreCase(url.getScheme()));
    }

    private ServiceInstance attemptToMatchIpAndPort(String serviceId) {
        if (!ValidateUtil.isIpOrIpAndPort((String)serviceId)) {
            return null;
        }
        String[] ipAndPorts = serviceId.split(":");
        if (ipAndPorts.length == 1) {
            return new DefaultServiceInstance(serviceId, serviceId, serviceId, 8080, false);
        }
        return new DefaultServiceInstance(serviceId, serviceId, ipAndPorts[0], Integer.parseInt(ipAndPorts[1]), false);
    }

    private <T> String routeService(String serviceId, Request<T> request) {
        String targetServiceId = this.attemptToMatchServiceMethod(serviceId, request);
        if (CharSequenceUtil.isBlank((CharSequence)targetServiceId) && CollUtil.isNotEmpty(this.properties.getServiceRouter())) {
            targetServiceId = this.properties.getServiceRouter().get(serviceId);
        }
        if (CharSequenceUtil.isBlank((CharSequence)targetServiceId)) {
            return serviceId;
        }
        logger.info("service router: {} -> {}", (Object)serviceId, (Object)targetServiceId);
        return targetServiceId;
    }

    private <T> String attemptToMatchServiceMethod(String serviceId, Request<T> request) {
        if (CollUtil.isEmpty(this.properties.getServiceMethodRouters())) {
            return null;
        }
        RequestData requestData = this.obtainRequestDataFromContext(request.getContext());
        if (requestData == null) {
            return null;
        }
        PathContainer pathContainer = PathContainer.parsePath((String)requestData.getUrl().getPath());
        for (CloudtOpenFeignProperties.ServiceMethodRouter serviceMethodRouter : this.properties.getServiceMethodRouters()) {
            if (!serviceId.equals(serviceMethodRouter.getService()) && !"*".equals(serviceMethodRouter.getService()) || serviceMethodRouter.getUriMethod() != null && requestData.getHttpMethod() != serviceMethodRouter.getUriMethod() || CharSequenceUtil.isBlank((CharSequence)serviceMethodRouter.getUri()) || CharSequenceUtil.isBlank((CharSequence)serviceMethodRouter.getTargetService())) continue;
            PathPattern pathPattern = (PathPattern)this.serviceMethodPatterns.getIfPresent((Object)serviceMethodRouter.getUri());
            if (pathPattern == null) {
                pathPattern = PathPatternParser.defaultInstance.parse(serviceMethodRouter.getUri());
                this.serviceMethodPatterns.put((Object)serviceMethodRouter.getUri(), (Object)pathPattern);
            }
            if (!pathPattern.matches(pathContainer)) continue;
            return serviceMethodRouter.getTargetService();
        }
        return null;
    }

    private ServiceInstance attemptToMatchLocalService(String serviceId) {
        if (this.applicationName != null && this.applicationName.equals(serviceId)) {
            return this.serviceInstance;
        }
        return null;
    }

    private <T> RequestData obtainRequestDataFromContext(T context) {
        if (!(context instanceof DefaultRequestContext)) {
            return null;
        }
        Object clientRequest = ((DefaultRequestContext)context).getClientRequest();
        if (!(clientRequest instanceof RequestData)) {
            return null;
        }
        return (RequestData)clientRequest;
    }

    private ServiceInstance buildLocalInstance() {
        return new DefaultServiceInstance(this.applicationName, this.applicationName, "127.0.0.1", this.port.intValue(), false);
    }
}

