/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.openfeign.config;

import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.common.CloudtBootLoggerFactory;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import org.slf4j.Logger;
import org.springframework.util.StringUtils;

class FeignAuthenticationContextInterceptor
implements RequestInterceptor {
    private static final Logger logger = CloudtBootLoggerFactory.RPC_OPENFEIGN.getLogger(FeignAuthenticationContextInterceptor.class);

    FeignAuthenticationContextInterceptor() {
    }

    public void apply(RequestTemplate template) {
        GeneralUserDetails user = SecurityContextUtil.currentUser();
        if (user == null) {
            logger.debug("\u8c03\u7528OpenFeign\u65f6\u4f20\u9012\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff0c\u672a\u83b7\u53d6\u5230\u5f53\u524d\u7528\u6237\u4fe1\u606f");
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("OpenFeign\u8c03\u7528\uff0c\u4f20\u9012Token\uff1a{}", (Object)SecurityContextUtil.currentToken());
        }
        if (user.getUser() != null) {
            template.header("current_user_id", new String[]{user.getUser().getId().toString()});
            template.header("current_user_name", new String[]{user.getUser().getUsername()});
            String token = SecurityContextUtil.currentToken();
            if (StringUtils.hasText((String)token)) {
                template.header("current_auth_token", new String[]{token});
                template.header("Authorization", new String[]{"Bearer " + token});
            }
        } else {
            template.removeHeader("current_user_id");
            template.removeHeader("current_user_name");
            template.removeHeader("current_auth_token");
            template.removeHeader("Authorization");
        }
    }
}

