/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.redis;

import cn.hutool.core.util.ArrayUtil;
import com.elitescloud.boot.redis.CloudtRedisProperties;
import com.elitescloud.boot.redis.common.RedisMessageSubscribe;
import com.elitescloud.boot.redis.common.support.RedisKeyPrefix;
import com.elitescloud.boot.redis.support.RedisMessageDelegate;
import com.elitescloud.boot.wrapper.RedisWrapper;
import com.elitescloud.cloudt.common.config.cache.CacheKeyGenerator;
import com.elitescloud.cloudt.common.util.RedLockUtils;
import com.elitescloud.cloudt.common.util.RedisUtils;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.redisson.api.RedissonClient;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.data.redis.RedisProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cache.CacheManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.data.redis.cache.RedisCacheConfiguration;
import org.springframework.data.redis.cache.RedisCacheManager;
import org.springframework.data.redis.cache.RedisCacheWriter;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.listener.ChannelTopic;
import org.springframework.data.redis.listener.PatternTopic;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;
import org.springframework.data.redis.serializer.JdkSerializationRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.util.StringUtils;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={CloudtRedisProperties.class, RedisProperties.class})
@ConditionalOnClass(value={RedisTemplate.class})
public class CloudtRedisAutoConfiguration {
    private static final Logger log = LogManager.getLogger(CloudtRedisAutoConfiguration.class);
    private final CloudtRedisProperties cloudtRedisProperties;

    public CloudtRedisAutoConfiguration(CloudtRedisProperties cloudtRedisProperties) {
        this.cloudtRedisProperties = cloudtRedisProperties;
    }

    @Bean
    public RedisUtils redisUtils(RedisTemplate<Object, Object> redisTemplate, CacheKeyGenerator keyGenerator) {
        return new RedisUtils(redisTemplate, keyGenerator);
    }

    @Bean
    public RedLockUtils redLockUtils(CacheKeyGenerator keyGenerator, ObjectProvider<RedissonClient> redissonClientObjectProvider) {
        return new RedLockUtils(keyGenerator, redissonClientObjectProvider);
    }

    @Bean
    @ConditionalOnMissingBean(value={RedisWrapper.class})
    public RedisWrapper redisWrapper() {
        return (supplier, param) -> supplier.get();
    }

    @Bean
    @ConditionalOnMissingBean
    public RedisKeyPrefix redisKeyPrefixDefault() {
        return () -> "tenant_default";
    }

    @Bean
    public CacheKeyGenerator redisCacheKeyGenerator(RedisKeyPrefix redisKeyPrefix) {
        return key -> {
            String keyPrefix;
            Object pre = "";
            if (StringUtils.hasText((String)this.cloudtRedisProperties.getPrefix())) {
                pre = this.cloudtRedisProperties.getPrefix() + ":";
            }
            if (redisKeyPrefix != null && StringUtils.hasText((String)(keyPrefix = redisKeyPrefix.getKeyPrefix()))) {
                pre = (String)pre + keyPrefix + ":";
            }
            if (key.indexOf((String)pre) == 0) {
                return key;
            }
            return (String)pre + key;
        };
    }

    @Bean
    @Primary
    public RedisTemplate redisTemplate(RedisConnectionFactory redisConnectionFactory, CacheKeyGenerator cacheKeyGenerator) {
        RedisTemplate template = new RedisTemplate();
        RedisSerializer<String> redisSerializer = this.redisSerializer(cacheKeyGenerator);
        template.setConnectionFactory(redisConnectionFactory);
        template.setKeySerializer(redisSerializer);
        template.setHashKeySerializer((RedisSerializer)new StringRedisSerializer());
        template.setValueSerializer((RedisSerializer)new JdkSerializationRedisSerializer());
        template.setHashValueSerializer((RedisSerializer)new JdkSerializationRedisSerializer());
        return template;
    }

    @Bean
    @Primary
    public CacheManager redisCacheManager(RedisConnectionFactory redisConnectionFactory, CacheKeyGenerator cacheKeyGenerator) {
        return new RedisCacheManager(RedisCacheWriter.lockingRedisCacheWriter((RedisConnectionFactory)redisConnectionFactory), RedisCacheConfiguration.defaultCacheConfig().disableCachingNullValues().computePrefixWith(cacheKeyGenerator::computeKey));
    }

    @Bean
    @ConditionalOnBean(value={RedisMessageSubscribe.class})
    public RedisMessageListenerContainer redisMessageListenerContainer(RedisConnectionFactory redisConnectionFactory, RedisTemplate redisTemplate, ObjectProvider<RedisMessageSubscribe> subscribeObjectProvider) {
        RedisMessageListenerContainer container = new RedisMessageListenerContainer();
        container.setConnectionFactory(redisConnectionFactory);
        for (RedisMessageSubscribe redisMessageSubscribe : subscribeObjectProvider) {
            this.addSubscriber(container, redisMessageSubscribe, (RedisSerializer<String>)redisTemplate.getStringSerializer(), redisTemplate.getValueSerializer());
        }
        return container;
    }

    private void addSubscriber(RedisMessageListenerContainer container, RedisMessageSubscribe subscribe, RedisSerializer<String> channelSerializer, RedisSerializer<?> valueSerializer) {
        List topics;
        if (ArrayUtil.isEmpty((Object[])subscribe.channel()) && ArrayUtil.isEmpty((Object[])subscribe.channelPattern())) {
            throw new IllegalStateException(subscribe.getClass().getName() + "\u672a\u914d\u7f6e\u76d1\u542c\u7684channel");
        }
        if (ArrayUtil.isNotEmpty((Object[])subscribe.channel())) {
            topics = Arrays.stream(subscribe.channel()).distinct().map(ChannelTopic::new).collect(Collectors.toList());
            container.addMessageListener((MessageListener)new RedisMessageDelegate(subscribe, channelSerializer, valueSerializer), topics);
        }
        if (ArrayUtil.isNotEmpty((Object[])subscribe.channelPattern())) {
            topics = Arrays.stream(subscribe.channelPattern()).distinct().map(PatternTopic::new).collect(Collectors.toList());
            container.addMessageListener((MessageListener)new RedisMessageDelegate(subscribe, channelSerializer, valueSerializer), topics);
        }
    }

    private RedisSerializer<String> redisSerializer(final CacheKeyGenerator cacheKeyGenerator) {
        return new RedisSerializer<String>(){
            private final Charset charset = StandardCharsets.UTF_8;

            public String deserialize(byte[] bytes) {
                if (bytes == null) {
                    return null;
                }
                return new String(bytes, this.charset);
            }

            public byte[] serialize(String key) {
                if (key == null) {
                    return new byte[0];
                }
                key = cacheKeyGenerator.computeKey(key);
                return key.getBytes(this.charset);
            }
        };
    }
}

