package com.elitescloud.boot.redis.support;

import com.elitescloud.boot.redis.common.RedisMessageSubscribe;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.redis.connection.Message;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.lang.NonNull;

import java.io.Serializable;

/**
 * Redis订阅的消息代理.
 *
 * @author Kaiser（wang shao）
 * @date 2023/6/1
 */
@Slf4j
public class RedisMessageDelegate implements MessageListener {

    private final RedisMessageSubscribe delegate;
    private final RedisSerializer<String> channelSerializer;
    private final RedisSerializer<?> valueSerializer;

    public RedisMessageDelegate(RedisMessageSubscribe messageSubscribe,
                                RedisSerializer<String> channelSerializer,
                                RedisSerializer<?> valueSerializer) {
        this.delegate = messageSubscribe;
        this.channelSerializer = channelSerializer;
        this.valueSerializer = valueSerializer;
    }

    @Override
    public void onMessage(@NonNull Message message, byte[] pattern) {
        try {
            this.handle(message, pattern);
        } catch (Throwable throwable) {
            log.error("处理Redis订阅消息异常：", throwable);
        }
    }

    private void handle(Message message, byte[] pattern) {
        var channel = channelSerializer.deserialize(pattern);
        log.info("Received Redis Message:{}", channel);
        var obj = valueSerializer.deserialize(message.getBody());

        delegate.onMessage((Serializable) obj, channel);
    }
}
