package com.elitescloud.boot.redis.redisson;

import com.elitescloud.boot.redis.CloudtRedisProperties;
import org.redisson.config.*;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

/**
 * redisson相关配置.
 *
 * @author Kaiser（wang shao）
 * @date 2022/5/23
 */
public class RedissonCustomProperties {

    public static final String CONFIG_PREFIX = CloudtRedisProperties.CONFIG_PREFIX + ".redisson";

    /**
     * 是否启用redisson配置
     */
    private Boolean enabled;

    /**
     * 集群模式
     */
    private final ClusterServersConfig clusterServersConfig = new ClusterServersConfig();

    /**
     * 单点模式
     */
    private final SingleServerConfig singleServerConfig = new CloudtSingleServerConfig();

    /**
     * 主从模式
     */
    private final MasterSlaveServersConfig masterSlaveServersConfig = new MasterSlaveServersConfig();

    /**
     * 单主节点模式
     */
    private final ReplicatedServersConfig replicatedServersConfig = new ReplicatedServersConfig();

    /**
     * 哨兵模式
     */
    private final SentinelServersConfig sentinelServersConfig = new SentinelServersConfig();

    public Boolean getEnabled() {
        return enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public ClusterServersConfig getClusterServersConfig() {
        return clusterServersConfig;
    }

    public SingleServerConfig getSingleServerConfig() {
        return singleServerConfig;
    }

    public MasterSlaveServersConfig getMasterSlaveServersConfig() {
        return masterSlaveServersConfig;
    }

    public ReplicatedServersConfig getReplicatedServersConfig() {
        return replicatedServersConfig;
    }

    public SentinelServersConfig getSentinelServersConfig() {
        return sentinelServersConfig;
    }

    public Config buildConfig() {
        CustomConfig config = new CustomConfig();
        if (!CollectionUtils.isEmpty(getClusterServersConfig().getNodeAddresses())) {
            config.setClusterServersConfig(getClusterServersConfig());
            return config;
        }

        if (StringUtils.hasText(getSingleServerConfig().getAddress())) {
            config.setSingleServerConfig(getSingleServerConfig());
            return config;
        }

        if (StringUtils.hasText(getMasterSlaveServersConfig().getMasterAddress())) {
            config.setMasterSlaveServersConfig(getMasterSlaveServersConfig());
            return config;
        }

        if (!CollectionUtils.isEmpty(getReplicatedServersConfig().getNodeAddresses())) {
            config.setReplicatedServersConfig(getReplicatedServersConfig());
            return config;
        }

        if (!CollectionUtils.isEmpty(getSentinelServersConfig().getSentinelAddresses())) {
            config.setSentinelServersConfig(getSentinelServersConfig());
            return config;
        }

        // 默认返回空
        return null;
    }

    static class CustomConfig extends Config {
        @Override
        public void setClusterServersConfig(ClusterServersConfig clusterServersConfig) {
            super.setClusterServersConfig(clusterServersConfig);
        }

        @Override
        public void setReplicatedServersConfig(ReplicatedServersConfig replicatedServersConfig) {
            super.setReplicatedServersConfig(replicatedServersConfig);
        }

        @Override
        public void setSingleServerConfig(SingleServerConfig singleConnectionConfig) {
            super.setSingleServerConfig(singleConnectionConfig);
        }

        @Override
        public void setSentinelServersConfig(SentinelServersConfig sentinelConnectionConfig) {
            super.setSentinelServersConfig(sentinelConnectionConfig);
        }

        @Override
        public void setMasterSlaveServersConfig(MasterSlaveServersConfig masterSlaveConnectionConfig) {
            super.setMasterSlaveServersConfig(masterSlaveConnectionConfig);
        }
    }
}
