package com.elitescloud.boot.redis.util;

import com.elitescloud.boot.redis.common.CacheKeyGenerator;
import com.elitescloud.boot.exception.BusinessException;
import org.redisson.RedissonRedLock;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.springframework.beans.factory.ObjectProvider;

import java.util.List;
import java.util.stream.Collectors;

public class RedLockUtils {

    private static final String LOCK_NAME_PREFIX = "RedLock:";

    private final CacheKeyGenerator keyGenerator;

    private final ObjectProvider<RedissonClient> redissonClientObjectProvider;

    public RedLockUtils(CacheKeyGenerator keyGenerator, ObjectProvider<RedissonClient> redissonClientObjectProvider) {
        this.keyGenerator = keyGenerator;
        this.redissonClientObjectProvider = redissonClientObjectProvider;
    }

    public RedissonRedLock getRedLock(String lockName) {
        if (getRedissonClients().isEmpty()) {
            throw new BusinessException("请确认redisson是否已正确配置");
        }

        // 获取所有的锁
        RLock[] rLocks = getRedissonClients().stream()
                .map(t -> t.getLock(keyGenerator.computeKey(LOCK_NAME_PREFIX + lockName)))
                .toArray(RLock[]::new);
        return new RedissonRedLock(rLocks);
    }

    public boolean isHeldByThread(String lockName, Long threadId) {
        // 获取所有的状态
        List<Boolean> statusList = getRedissonClients().stream()
                .map(t -> t.getLock(keyGenerator.computeKey(LOCK_NAME_PREFIX + lockName)).isHeldByThread(threadId))
                .collect(Collectors.toList());

        for (Boolean st : statusList) {
            if (Boolean.FALSE.equals(st)) {
                return false;
            }
        }
        return true;
    }

    private List<RedissonClient> getRedissonClients() {
        if (redissonClients == null) {
            redissonClients = redissonClientObjectProvider.stream().collect(Collectors.toList());
        }
        return redissonClients;
    }

    private List<RedissonClient> redissonClients;
}
