package com.elitescloud.boot.redis;

import com.elitescloud.boot.redis.redisson.RedissonCustomProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

/**
 * redis属性配置.
 *
 * @author Kaiser（wang shao）
 * @date 2022/4/11
 */
@ConfigurationProperties(prefix = CloudtRedisProperties.CONFIG_PREFIX)
public class CloudtRedisProperties {

    public static final String CONFIG_PREFIX = "elitesland.redis";

    /**
     * 前缀
     */
    private String prefix;

    /**
     * redisson配置
     */
    @NestedConfigurationProperty
    private RedissonCustomProperties redisson = new RedissonCustomProperties();

    public String getPrefix() {
        return prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public RedissonCustomProperties getRedisson() {
        return redisson;
    }

    public void setRedisson(RedissonCustomProperties redisson) {
        this.redisson = redisson;
    }
}
