package com.elitescloud.boot.redis.common;

import java.io.Serializable;

/**
 * Redis消息订阅.
 *
 * @author Kaiser（wang shao）
 * @date 2023/6/1
 */
public interface RedisMessageSubscribe {

    /**
     * 订阅渠道
     *
     * @return 渠道名称
     */
    String[] channel();

    /**
     * 订阅的渠道模式
     * <p>
     * 可使用*来进行统配，与 {@link #channel()} 配置一个即可
     *
     * @return 渠道模式
     */
    default String[] channelPattern() {
        return new String[0];
    }

    /**
     * 处理消息
     *
     * @param message 消息
     * @param channel 消息渠道
     * @param <T>     消息类型
     */
    <T extends Serializable> void onMessage(T message, String channel);
}
