/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.redis;

import cn.hutool.core.util.ArrayUtil;
import com.elitescloud.boot.common.CloudtBootLoggerFactory;
import com.elitescloud.boot.redis.CloudtRedisProperties;
import com.elitescloud.boot.redis.common.CacheKeyGenerator;
import com.elitescloud.boot.redis.common.RedisMessageSubscribe;
import com.elitescloud.boot.redis.common.support.RedisKeyPrefix;
import com.elitescloud.boot.redis.common.support.RedisSerializerProvider;
import com.elitescloud.boot.redis.support.DefaultRedisSerializerProvider;
import com.elitescloud.boot.redis.support.RedisMessageDelegate;
import com.elitescloud.boot.threadpool.common.ThreadPoolHolder;
import com.elitescloud.boot.wrapper.RedisWrapper;
import com.elitescloud.cloudt.common.util.RedLockUtils;
import com.elitescloud.cloudt.common.util.RedisUtils;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.data.redis.RedisProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cache.CacheManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Primary;
import org.springframework.data.redis.cache.RedisCacheConfiguration;
import org.springframework.data.redis.cache.RedisCacheManager;
import org.springframework.data.redis.cache.RedisCacheWriter;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.listener.ChannelTopic;
import org.springframework.data.redis.listener.PatternTopic;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.stream.StreamMessageListenerContainer;
import org.springframework.util.StringUtils;

@EnableConfigurationProperties(value={CloudtRedisProperties.class, RedisProperties.class})
@ConditionalOnClass(value={RedisTemplate.class})
public class CloudtRedisAutoConfiguration {
    private static final Logger logger = CloudtBootLoggerFactory.CACHE_REDIS.getLogger(CloudtRedisAutoConfiguration.class);
    private final CloudtRedisProperties cloudtRedisProperties;

    public CloudtRedisAutoConfiguration(CloudtRedisProperties cloudtRedisProperties) {
        this.cloudtRedisProperties = cloudtRedisProperties;
    }

    @Bean
    @ConditionalOnMissingBean
    public RedisKeyPrefix redisKeyPrefixDefault() {
        return () -> "tenant_default";
    }

    @Bean
    @ConditionalOnMissingBean(value={RedisWrapper.class})
    public RedisWrapper redisWrapper() {
        return new RedisWrapper(){

            public <R, T> R apply(Supplier<R> supplier, T param) {
                return supplier.get();
            }
        };
    }

    @Bean
    public com.elitescloud.cloudt.common.config.cache.CacheKeyGenerator redisCacheKeyGenerator(RedisKeyPrefix redisKeyPrefix) {
        return key -> {
            String keyPrefix;
            Object pre = "";
            if (StringUtils.hasText((String)this.cloudtRedisProperties.getPrefix())) {
                pre = this.cloudtRedisProperties.getPrefix() + ":";
            }
            if (redisKeyPrefix != null && StringUtils.hasText((String)(keyPrefix = redisKeyPrefix.getKeyPrefix()))) {
                pre = (String)pre + keyPrefix + ":";
            }
            if (key.indexOf((String)pre) == 0) {
                return key;
            }
            return (String)pre + key;
        };
    }

    @Bean
    public RedisSerializerProvider defaultRedisSerializerProvider(CacheKeyGenerator cacheKeyGenerator) {
        return new DefaultRedisSerializerProvider(cacheKeyGenerator);
    }

    @Bean(value={"redisTemplate"})
    @Primary
    public RedisTemplate redisTemplate(RedisConnectionFactory redisConnectionFactory, RedisSerializerProvider redisSerializerProvider) {
        RedisTemplate template = new RedisTemplate();
        template.setConnectionFactory(redisConnectionFactory);
        template.setKeySerializer(redisSerializerProvider.keySerializer());
        template.setHashKeySerializer(redisSerializerProvider.hashKeySerializer());
        template.setValueSerializer(redisSerializerProvider.valueSerializer());
        template.setHashValueSerializer(redisSerializerProvider.hashValueSerializer());
        template.setStringSerializer(redisSerializerProvider.stringSerializer());
        template.setEnableDefaultSerializer(false);
        return template;
    }

    @Bean(value={"stringRedisTemplate"})
    public StringRedisTemplate stringRedisTemplate(RedisTemplate redisTemplate) {
        StringRedisTemplate template = new StringRedisTemplate();
        template.setConnectionFactory(redisTemplate.getConnectionFactory());
        template.setKeySerializer(redisTemplate.getKeySerializer());
        template.setValueSerializer(redisTemplate.getStringSerializer());
        template.setHashKeySerializer(redisTemplate.getHashKeySerializer());
        template.setHashValueSerializer(redisTemplate.getStringSerializer());
        template.setStringSerializer(redisTemplate.getStringSerializer());
        template.setEnableDefaultSerializer(redisTemplate.isEnableDefaultSerializer());
        return template;
    }

    @Bean
    @ConditionalOnBean(value={RedisMessageSubscribe.class})
    public RedisMessageListenerContainer redisMessageListenerContainer(RedisConnectionFactory redisConnectionFactory, RedisTemplate redisTemplate, StringRedisTemplate stringRedisTemplate, ObjectProvider<RedisMessageSubscribe> subscribeObjectProvider) {
        RedisMessageListenerContainer container = new RedisMessageListenerContainer();
        container.setConnectionFactory(redisConnectionFactory);
        for (RedisMessageSubscribe redisMessageSubscribe : subscribeObjectProvider) {
            this.addSubscriber(container, redisMessageSubscribe, (RedisSerializer<String>)stringRedisTemplate.getKeySerializer(), redisTemplate.getValueSerializer());
        }
        return container;
    }

    @Bean
    public StreamMessageListenerContainer.StreamMessageListenerContainerOptions streamMessageListenerContainerOptions(RedisTemplate redisTemplate) {
        CloudtRedisProperties.Stream props = this.cloudtRedisProperties.getStream();
        ThreadPoolExecutor executor = ThreadPoolHolder.createThreadPool((String)props.getThreadPrefix(), (Integer)props.getThreadCoreSize(), (Integer)props.getThreadMaxSize());
        return StreamMessageListenerContainer.StreamMessageListenerContainerOptions.builder().keySerializer(redisTemplate.getKeySerializer()).hashKeySerializer(redisTemplate.getHashKeySerializer()).hashValueSerializer(redisTemplate.getHashValueSerializer()).executor((Executor)executor).pollTimeout(props.getPoolTimeOut()).batchSize(props.getBatchSize()).errorHandler(t -> logger.error("Redis Stream\u5f02\u5e38\uff1a", t)).build();
    }

    @Bean
    public StreamMessageListenerContainer streamMessageListenerContainer(RedisConnectionFactory connectionFactory, StreamMessageListenerContainer.StreamMessageListenerContainerOptions options) {
        StreamMessageListenerContainer container = StreamMessageListenerContainer.create((RedisConnectionFactory)connectionFactory, (StreamMessageListenerContainer.StreamMessageListenerContainerOptions)options);
        container.start();
        return container;
    }

    @Bean
    public RedisUtils redisUtils(RedisTemplate<Object, Object> redisTemplate, StreamMessageListenerContainer streamMessageListenerContainer, CacheKeyGenerator keyGenerator) {
        return new RedisUtils(redisTemplate, streamMessageListenerContainer, keyGenerator);
    }

    @Bean
    public RedLockUtils redLockUtils(CacheKeyGenerator keyGenerator, ObjectProvider<RedissonClient> redissonClientObjectProvider) {
        return new RedLockUtils(keyGenerator, redissonClientObjectProvider);
    }

    @Bean
    @Primary
    public CacheManager redisCacheManager(RedisConnectionFactory redisConnectionFactory, CacheKeyGenerator cacheKeyGenerator) {
        return new RedisCacheManager(RedisCacheWriter.lockingRedisCacheWriter((RedisConnectionFactory)redisConnectionFactory), RedisCacheConfiguration.defaultCacheConfig().disableCachingNullValues().computePrefixWith(cacheKeyGenerator::computeKey));
    }

    private void addSubscriber(RedisMessageListenerContainer container, RedisMessageSubscribe subscribe, RedisSerializer<String> channelSerializer, RedisSerializer<?> valueSerializer) {
        List topics;
        if (ArrayUtil.isEmpty((Object[])subscribe.channel()) && ArrayUtil.isEmpty((Object[])subscribe.channelPattern())) {
            throw new IllegalStateException(subscribe.getClass().getName() + "\u672a\u914d\u7f6e\u76d1\u542c\u7684channel");
        }
        if (ArrayUtil.isNotEmpty((Object[])subscribe.channel())) {
            topics = Arrays.stream(subscribe.channel()).distinct().map(ChannelTopic::new).collect(Collectors.toList());
            container.addMessageListener((MessageListener)new RedisMessageDelegate(subscribe, channelSerializer, valueSerializer), topics);
        }
        if (ArrayUtil.isNotEmpty((Object[])subscribe.channelPattern())) {
            topics = Arrays.stream(subscribe.channelPattern()).distinct().map(PatternTopic::new).collect(Collectors.toList());
            container.addMessageListener((MessageListener)new RedisMessageDelegate(subscribe, channelSerializer, valueSerializer), topics);
        }
    }
}

